package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.readers.MojoReaderBackend;

abstract public class MojoTransformBuilderFactory {

  /**
   * Identification of custom builder factory.
   *
   * This identification is used to find matching custom builder when
   * loading from Proto state.
   * @return unique identification of the builder (default is canonical class name)
   */
  public String implementationId() {
    return this.getClass().getCanonicalName();
  }

  /**
   * Create a transformation builder.
   *
   * @param meta
   * @param iindcies
   * @param oindices
   * @param stateFileName name of file which contains a stored state (or list of additional files)
   * @param backend  reader backend to read content of stateFile
   * @return a new transformation builder
   */
  abstract public MojoTransformBuilder createBuilder(MojoFrameMeta meta,
                                                     int[] iindcies, int[] oindices,
                                                     String stateFileName,
                                                     MojoReaderBackend backend);


}