package ai.h2o.mojos.runtime.readers;

import java.io.*;

/**
 * The backend serves MOJO content from a folder.
 */
public class FolderMojoReaderBackend extends MojoReaderBackend {

  public FolderMojoReaderBackend(String folder) {
    this(folder, null);
  }

  public FolderMojoReaderBackend(String folder, String pipelineFile) {
    super(folder, File.separator, pipelineFile);
  }

  @Override
  public InputStream getFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    return new FileInputStream(f);
  }

  @Override
  public BufferedReader getTextFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    FileReader fr = new FileReader(f);
    return new BufferedReader(fr);
  }

  @Override
  public byte[] getBinaryFile(String filename) throws IOException {
    File f = new File(getBaseDir(), filename);
    byte[] out = new byte[(int) f.length()];
    DataInputStream dis = new DataInputStream(new FileInputStream(f));
    dis.readFully(out);
    return out;
  }

  @Override
  public String[] getFileNames(String path) throws IOException {
    File base = new File(getBaseDir(), path);
    File[] allFiles = base.listFiles();

    String[] fileNames = new String[allFiles.length];
    int numFiles = 0;
    for (File f : allFiles) {
      if (f.isFile()) {
        fileNames[numFiles] = f.getName();
        numFiles += 1;
      }
    }
    if (fileNames.length == numFiles) {
      return fileNames;
    }
    String[] out = new String[numFiles];
    System.arraycopy(fileNames, 0, out, 0, numFiles);
    return out;
  }

  @Override
  public String[] getDirectoryNames(String path) throws IOException {
    File base = new File(getBaseDir(), path);
    File[] allFiles = base.listFiles();

    String[] dirNames = new String[allFiles.length];
    int numDirs = 0;
    for (File f : allFiles) {
      if (f.isDirectory()) {
        dirNames[numDirs] = f.getName();
        numDirs += 1;
      }
    }
    if (dirNames.length == numDirs) {
      return dirNames;
    }
    String[] out = new String[numDirs];
    System.arraycopy(dirNames, 0, out, 0, numDirs);
    return out;
  }

  @Override
  public boolean exists(String filename) {
    return new File(getBaseDir(), filename).exists();
  }

  @Override public void close() {}
}
