package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.readers.MojoReaderBackend;

import java.util.Map;

/**
 * Binds a custom transformer to a unique name, by which it can be referenced from within mojo2 file.
 * Every custom transformer must define a class implementing this interface.
 * That class must be registered using {@link java.util.ServiceLoader} mechanism (= listed in META-INF/services/ai.h2o.mojos.runtime.transforms.MojoTransformBuilderFactory resource).
 */
public interface MojoTransformBuilderFactory {

  /**
   * Identification of custom transformer.
   *
   * Used to identify transformer instantiator when loading from ProtoBuf state.
   * Must be unique per JVM.
   *
   * @return unique identification of the builder (default is canonical class name)
   */
  String transformerName();

  /**
   * Instantiate a transformation builder.
   *
   * @param meta
   * @param iindcies
   * @param oindices
   * @param params parameters of the custom transformer
   * @param backend  reader backend to read content of stateFile
   * @return a new transformation builder
   */
  MojoTransformBuilder createBuilder(MojoFrameMeta meta,
                                     int[] iindcies, int[] oindices,
                                     Map<String, Object> params,
                                     MojoReaderBackend backend);
}
