/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.readers;

import ai.h2o.mojos.runtime.readers.MojoReaderBackend;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

public class FolderMojoReaderBackend
extends MojoReaderBackend {
    public FolderMojoReaderBackend(String folder) {
        this(folder, null);
    }

    public FolderMojoReaderBackend(String folder, String pipelineFile) {
        super(folder, "/", pipelineFile);
    }

    @Override
    public InputStream getFile(String filename) throws IOException {
        File f = new File(this.getBaseDir(), filename);
        return new FileInputStream(f);
    }

    @Override
    public BufferedReader getTextFile(String filename) throws IOException {
        File f = new File(this.getBaseDir(), filename);
        FileReader fr = new FileReader(f);
        return new BufferedReader(fr);
    }

    @Override
    public byte[] getBinaryFile(String filename) throws IOException {
        File f = new File(this.getBaseDir(), filename);
        byte[] out = new byte[(int)f.length()];
        DataInputStream dis = new DataInputStream(new FileInputStream(f));
        dis.readFully(out);
        return out;
    }

    @Override
    public String[] getFileNames(String path) throws IOException {
        File base = new File(this.getBaseDir(), path);
        File[] allFiles = base.listFiles();
        String[] fileNames = new String[allFiles.length];
        int numFiles = 0;
        for (File f : allFiles) {
            if (!f.isFile()) continue;
            fileNames[numFiles] = f.getName();
            ++numFiles;
        }
        if (fileNames.length == numFiles) {
            return fileNames;
        }
        String[] out = new String[numFiles];
        System.arraycopy(fileNames, 0, out, 0, numFiles);
        return out;
    }

    @Override
    public String[] getDirectoryNames(String path) throws IOException {
        File base = new File(this.getBaseDir(), path);
        File[] allFiles = base.listFiles();
        String[] dirNames = new String[allFiles.length];
        int numDirs = 0;
        for (File f : allFiles) {
            if (!f.isDirectory()) continue;
            dirNames[numDirs] = f.getName();
            ++numDirs;
        }
        if (dirNames.length == numDirs) {
            return dirNames;
        }
        String[] out = new String[numDirs];
        System.arraycopy(dirNames, 0, out, 0, numDirs);
        return out;
    }

    @Override
    public boolean exists(String filename) {
        return new File(this.getBaseDir(), filename).exists();
    }

    @Override
    public void close() {
    }
}

