/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MojoFrameMeta
implements Serializable {
    private final List<MojoColumnMeta> columns;
    private final Map<String, Integer> columnNameToIndex = new HashMap<String, Integer>();

    public MojoFrameMeta(List<MojoColumnMeta> columns) {
        this.columns = columns;
        int index = 0;
        for (MojoColumnMeta column : columns) {
            this.columnNameToIndex.put(column.getColumnName(), index);
            ++index;
        }
    }

    public static MojoFrameMeta getEmpty() {
        return new MojoFrameMeta(Collections.emptyList());
    }

    protected void internalAdd(MojoColumnMeta column) {
        this.columnNameToIndex.put(column.getColumnName(), this.columns.size());
        this.columns.add(column);
    }

    public int getColumnIndex(String columnName) {
        return this.columnNameToIndex.get(columnName);
    }

    public String getColumnName(int index) {
        return this.columns.get(index).getColumnName();
    }

    public MojoColumn.Type getColumnType(int index) {
        return this.columns.get(index).getColumnType();
    }

    public MojoColumn.Type getColumnType(String columnName) {
        return this.getColumnType(this.getColumnIndex(columnName));
    }

    public boolean contains(String columnName) {
        return this.columnNameToIndex.containsKey(columnName);
    }

    public int size() {
        return this.columns.size();
    }

    protected Map<String, Integer> getColumnNamesMap() {
        return this.columnNameToIndex;
    }

    @Deprecated
    public String[] getColumnNames() {
        return this.columnNameToIndex.keySet().toArray(new String[0]);
    }

    @Deprecated
    public MojoColumn.Type[] getColumnTypes() {
        MojoColumn.Type[] columnTypes = new MojoColumn.Type[this.columns.size()];
        for (int i = 0; i < columnTypes.length; ++i) {
            columnTypes[i] = this.columns.get(i).getColumnType();
        }
        return columnTypes;
    }

    public List<MojoColumnMeta> getColumns() {
        return this.columns;
    }
}

