/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.api.BasePipelineListener;
import ai.h2o.mojos.runtime.api.MojoPipelineService;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.readers.MojoReaderBackend;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.joda.time.DateTime;

public abstract class MojoPipeline
implements Serializable {
    private final String uuid;
    private final DateTime timestamp;
    private final String license;

    protected MojoPipeline(String uuid, DateTime timestamp, String license) {
        this.uuid = uuid;
        this.timestamp = timestamp;
        this.license = license;
    }

    @Deprecated
    public static MojoPipeline loadFrom(String file) throws IOException, LicenseException {
        return MojoPipelineService.loadPipeline(new File(file));
    }

    @Deprecated
    public static MojoPipeline loadFrom(MojoReaderBackend mrb) throws IOException, LicenseException {
        return MojoPipelineService.loadPipeline(mrb.internalGetReaderBackend());
    }

    public String getUuid() {
        return this.uuid;
    }

    public DateTime getCreationTime() {
        return this.timestamp;
    }

    public String getLicense() {
        return this.license;
    }

    public MojoFrameBuilder getInputFrameBuilder() {
        return this.getFrameBuilder(MojoColumn.Kind.Feature);
    }

    protected abstract MojoFrameBuilder getFrameBuilder(MojoColumn.Kind var1);

    public MojoFrameMeta getInputMeta() {
        return this.getMeta(MojoColumn.Kind.Feature);
    }

    public MojoFrameMeta getOutputMeta() {
        return this.getMeta(MojoColumn.Kind.Output);
    }

    protected abstract MojoFrameMeta getMeta(MojoColumn.Kind var1);

    public MojoFrame transform(MojoFrameBuilder inputFrameBuilder) {
        return this.transform(inputFrameBuilder.toMojoFrame());
    }

    public MojoFrame transform(MojoFrame inputFrame) {
        MojoFrameMeta outputMeta = this.getMeta(MojoColumn.Kind.Output);
        MojoFrame outputFrame = MojoFrameBuilder.getEmpty(outputMeta, inputFrame.getNrows());
        return this.transform(inputFrame, outputFrame);
    }

    public abstract MojoFrame transform(MojoFrame var1, MojoFrame var2);

    public void setShapPredictContrib(boolean enable) {
        if (enable) {
            throw new IllegalArgumentException("SHAP is not supported for this pipeline");
        }
    }

    public abstract void setListener(BasePipelineListener var1);
}

