package ai.h2o.mojos.runtime.api;

import java.util.Map;

public class MojoTransformationGroup {
    private final int id;
    private final String name;

    public MojoTransformationGroup(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(final Map<Integer, MojoTransformationGroup> groups, final int groupId) {
        MojoTransformationGroup group = groups.get(groupId);
        if (group == null) {
            group = new MojoTransformationGroup(groupId, String.format("#undefined#%d", groupId));
            groups.put(groupId, group);
        }
        return group;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
