package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilder;

/** Uniform representation of a transformer */
public class MojoTransformMeta {
    private final String name;
    private final Object desc;
    private final int[] inputIndices;
    private final int[] outputIndices;
    private final int transformationIndex;
    private final MojoTransformationGroup transformationGroup;
    private MojoTransform transform;
    private MojoTransformBuilder transformBuilder;

    /**
     * WARNING: Do not use this constructor.
     * Only for internal use of mojo2 implementation.
     * Subject to change without notice.
     */
    public MojoTransformMeta(String name, Object desc, int[] inputIndices, int[] outputIndices, int transformationIndex, final MojoTransformationGroup transformationGroup) {
        this.name = name;
        this.desc = desc;
        this.inputIndices = inputIndices;
        this.outputIndices = outputIndices;
        this.transformationIndex = transformationIndex;
        this.transformationGroup = transformationGroup;
    }
    // todo maybe also input, output, params - later

    /**
     * Only for internal use - subject to change without notice
     */
    public MojoTransform getTransform() {
        return transform;
    }

    /**
     * Only for internal use - subject to change without notice
     */
    public void setTransform(MojoTransform transform) {
        this.transform = transform;
    }

    /**
     * Only for internal use - subject to change without notice
     */
    public MojoTransformBuilder getTransformBuilder() {
        return transformBuilder;
    }

    /**
     * Only for internal use - subject to change without notice
     */
    public void setTransformBuilder(final MojoTransformBuilder transformBuilder) {
        this.transformBuilder = transformBuilder;
    }

    public String getName() {
        return name;
    }

    /**
     * Description, can be multi-line.
     * @return object whose {@link #toString()} has the description
     */
    public Object getDesc() {
        return desc;
    }

    public int[] getInputIndices() {
        return inputIndices;
    }

    public int[] getOutputIndices() {
        return outputIndices;
    }

    /**
     * @return index of transformation operation in the pipeline, before removing unused part
     */
    public int getTransformationIndex() {
        return transformationIndex;
    }

    public MojoTransformationGroup getTransformationGroup() {
        return transformationGroup;
    }
}
