package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.lic.LicenseException;
import java.io.IOException;
import java.util.List;

/**
 * Representation of a pipeline
 */
public interface PipelineLoader {
    /**
     * @return list of all columns defined by pipeline
     */
    List<MojoColumnMeta> getColumns();

    /**
     * @return list of all transformations
     */
    List<MojoTransformMeta> getTransformations();

    /**
     * @return pipeline on which prediction can be computed
     */
    MojoPipeline load() throws IOException, LicenseException;
}
