/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.utils.MojoDateTime;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public abstract class MojoColumn
implements Serializable {
    @Deprecated
    public abstract String debug();

    public abstract Type getType();

    public abstract Object getData();

    public abstract String[] getDataAsStrings();

    public abstract int size();

    abstract void resize(int var1);

    abstract void fillFromParsedListData(List var1);

    public static enum Kind {
        Feature,
        Response,
        Output,
        Interim;

    }

    public static enum Type {
        Bool((Class)Byte.TYPE, (Object)-128, false, false, new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Boolean) {
                    return (Boolean)value != false ? (byte)1 : 0;
                }
                byte b = ((Number)value).byteValue();
                if (b == 1) {
                    return true;
                }
                if (b == 0) {
                    return false;
                }
                throw new IllegalArgumentException("Only 1 or 0 is allowed when storing data into Boolean column from numeric types.");
            }

            @Override
            protected Object parseImpl(String val) {
                return Type.parseBoolean(val) ? (byte)1 : 0;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Byte && ((Byte)val).byteValue() == ((Byte)this.ona).byteValue();
            }
        }
        ,
        Int32((Class)Integer.TYPE, (Object)Integer.MIN_VALUE, true, false, new Class[]{Byte.class, Short.class, Integer.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                return value;
            }

            @Override
            protected Object parseImpl(String val) {
                try {
                    return Integer.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        return Type.parseBoolean(val) ? 1 : 0;
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Integer && ((Integer)val).intValue() == ((Integer)this.ona).intValue();
            }
        }
        ,
        Int64((Class)Long.TYPE, (Object)Long.MIN_VALUE, true, false, new Class[]{Byte.class, Short.class, Integer.class, Long.class}){

            @Override
            protected Object parseImpl(String val) {
                try {
                    return Long.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        return Type.parseBoolean(val) ? 1L : 0L;
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Long && ((Long)val).longValue() == ((Long)this.ona).longValue();
            }
        }
        ,
        Float32((Class)Float.TYPE, (Object)Float.valueOf(Float.NaN), true, true, new Class[]{Byte.class, Short.class, Integer.class, Float.class, Double.class}){

            @Override
            protected Object parseImpl(String val) {
                try {
                    return Float.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        return Float.valueOf(Type.parseBoolean(val) ? 1.0f : 0.0f);
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return Float.valueOf(((Number)value).floatValue());
                }
                return value;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Float && Float.isNaN(((Float)val).floatValue());
            }
        }
        ,
        Float64((Class)Double.TYPE, (Object)Double.NaN, true, true, new Class[]{Byte.class, Short.class, Integer.class, Float.class, Long.class, Double.class}){

            @Override
            protected Object parseImpl(String val) {
                try {
                    return Double.valueOf(val);
                }
                catch (NumberFormatException nfe) {
                    try {
                        return Type.parseBoolean(val) ? 1.0 : 0.0;
                    }
                    catch (NumberFormatException tmp) {
                        throw nfe;
                    }
                }
            }

            @Override
            protected Object castFromJavaType(Object value) {
                if (value instanceof Number) {
                    return ((Number)value).doubleValue();
                }
                return value;
            }

            @Override
            public boolean isNA(Object val) {
                return val instanceof Double && Double.isNaN((Double)val);
            }
        }
        ,
        Str((Class)String.class, (Object)null, false, false, new Class[]{String.class, Character.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                return value != null ? value.toString() : null;
            }

            @Override
            public Object parse(String val) {
                if (val != null && val.length() > 1) {
                    int eidx = val.length() - 1;
                    if (val.charAt(0) == '\"' && val.charAt(eidx) == '\"') {
                        val = val.substring(1, eidx);
                    }
                }
                return val;
            }

            @Override
            protected Object parseImpl(String val) {
                throw new UnsupportedOperationException("This method should not be called!");
            }

            @Override
            public boolean isNA(Object val) {
                return val == this.ona;
            }
        }
        ,
        Time64((Class)MojoDateTime.class, (Object)null, false, false, new Class[]{Timestamp.class, Date.class}){

            @Override
            protected Object castFromJavaType(Object value) {
                return value != null ? MojoDateTime.parse(value.toString()) : null;
            }

            @Override
            protected Object parseImpl(String val) {
                return MojoDateTime.parse(val);
            }

            @Override
            public boolean isNA(Object val) {
                return val == this.ona;
            }
        };

        public final Object NULL;
        public final Class<?> javaclass;
        public final Object ona;
        public final boolean isnumeric;
        public final boolean isfloat;
        final HashSet<Class> assignableFromJavaTypes;

        private Type(Class<?> javaclass, Object ona, boolean isnumeric, boolean isfloat, Class[] assignableFromJavaTypes) {
            this.javaclass = javaclass;
            this.ona = ona;
            this.NULL = this.parse(null);
            this.isnumeric = isnumeric;
            this.isfloat = isfloat;
            this.assignableFromJavaTypes = new HashSet<Class>(Arrays.asList(assignableFromJavaTypes));
        }

        public Object parse(String val) {
            if (val == null || val.isEmpty()) {
                return this.ona;
            }
            return this.parseImpl(val);
        }

        private static boolean parseBoolean(String val) {
            char[] chars = (val = val.trim()).toCharArray();
            if (chars.length == 1) {
                if (chars[0] == '1') {
                    return true;
                }
                if (chars[0] == '0') {
                    return false;
                }
            } else if (chars.length == 4) {
                switch (chars[0]) {
                    case 'T': {
                        switch (chars[1]) {
                            case 'r': {
                                if (chars[2] != 'u' || chars[3] != 'e') break;
                                return true;
                            }
                            case 'R': {
                                if (chars[2] != 'U' || chars[3] != 'E') break;
                                return true;
                            }
                        }
                        break;
                    }
                    case 't': {
                        if (chars[1] != 'r' || chars[2] != 'u' || chars[3] != 'e') break;
                        return true;
                    }
                }
            } else if (chars.length == 5) {
                switch (chars[0]) {
                    case 'F': {
                        switch (chars[1]) {
                            case 'a': {
                                if (chars[2] != 'l' || chars[3] != 's' || chars[4] != 'e') break;
                                return false;
                            }
                            case 'A': {
                                if (chars[2] != 'L' || chars[3] != 'S' || chars[4] != 'E') break;
                                return false;
                            }
                        }
                        break;
                    }
                    case 'f': {
                        if (chars[1] != 'a' || chars[2] != 'l' || chars[3] != 's' || chars[4] != 'e') break;
                        return false;
                    }
                }
            }
            throw new NumberFormatException("For input string: \"" + val + "\"");
        }

        public boolean isAssignableFrom(Class javaClazz) {
            return this.assignableFromJavaTypes.contains(javaClazz);
        }

        private void failIfNotAssignableFrom(Class javaClazz) {
            if (!this.isAssignableFrom(javaClazz)) {
                throw new ClassCastException("Mojo column of type " + this.name() + " can be assigned Java values only from the following types: " + this.assignableFromJavaTypes.toString() + " , Java class on the input was: " + javaClazz.getSimpleName());
            }
        }

        protected Object castFromJavaType(Object value) {
            return value;
        }

        protected Object fromJavaClass(Object value) {
            if (value != null) {
                this.failIfNotAssignableFrom(value.getClass());
                return this.castFromJavaType(value);
            }
            return null;
        }

        protected abstract Object parseImpl(String var1);

        public abstract boolean isNA(Object var1);
    }
}

