package ai.h2o.mojos.runtime.api;

import java.util.Map;
import java.util.Objects;

public class MojoTransformationGroup {
    private final int id;
    private final String name;

    public MojoTransformationGroup(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(final Map<Integer, MojoTransformationGroup> groups, final int groupId) {
        MojoTransformationGroup group = groups.get(groupId);
        if (group == null) {
            group = new MojoTransformationGroup(groupId, String.format("#undefined#%d", groupId));
            groups.put(groupId, group);
        }
        return group;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final MojoTransformationGroup that = (MojoTransformationGroup) o;
        return id == that.id;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    @Override
    public String toString() {
        return String.format("G:%d{%s}", id, name);
    }
}
