/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import java.util.Map;
import java.util.Objects;

public class MojoTransformationGroup {
    private final int id;
    private final String name;

    public MojoTransformationGroup(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(Map<Integer, MojoTransformationGroup> groups, int groupId) {
        MojoTransformationGroup group = groups.get(groupId);
        if (group == null) {
            group = new MojoTransformationGroup(groupId, String.format("#undefined#%d", groupId));
            groups.put(groupId, group);
        }
        return group;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MojoTransformationGroup that = (MojoTransformationGroup)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("G:%d{%s}", this.id, this.name);
    }
}

