/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoTransformationGroup {
    private static final Logger log = LoggerFactory.getLogger(MojoTransformationGroup.class);
    private final int id;
    private final String name;

    public MojoTransformationGroup(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public static MojoTransformationGroup findGroup(Map<Integer, MojoTransformationGroup> groups, int groupId) {
        if (groupId == 0) {
            return null;
        }
        MojoTransformationGroup group = groups.get(groupId);
        if (group == null) {
            log.warn("Undefined group ID: {}", (Object)groupId);
            group = new MojoTransformationGroup(groupId, String.format("#undefined#%d", groupId));
            groups.put(groupId, group);
        }
        return group;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MojoTransformationGroup that = (MojoTransformationGroup)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return String.format("G:%d{%s}", this.id, this.name);
    }
}

