package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.transforms.MojoTransform;

/**
 * Listener, called by pipeline while processing the transformation.
 */
public class BasePipelineListener {
    /**
     * An instance of listener that ignores everything.
     */
    public static BasePipelineListener NOOP = new BasePipelineListener();

    /**
     * Called once before every batch.
     *
     * @param globalFrame global frame representing all values in the batch.
     *                    Implementation will typically need to remember it, for use in other methods
     *                    - {@link #onTransformStep(String, int)} and {@link #onTransformResult(MojoTransform)}
     */
    public void onBatchStart(final MojoFrame globalFrame) {
        //
    }

    /**
     * Called once after every batch.
     */
    public void onBatchEnd() {
        //
    }

    /**
     * Expose heading of current transformation.
     *
     * @param transform current transformation
     */
    public void onTransformHead(final MojoTransform transform) {
        //
    }

    /**
     * Step reporting callback.
     * Transformer calls it to expose intermediate values that have changed during recent step.
     * This method should be called once per each changed value during the step (if there are more).
     *
     * @param stepId simple but unique identification of the step; for instance "tree 23" - main rule is: it must be informative
     * @param oindex index of the column that has changed
     */
    public void onTransformStep(final String stepId, int oindex) {
        //
    }

    /**
     * Expose values of current transformation
     * @param transform current transformation
     */
    public void onTransformResult(final MojoTransform transform) {
        //
    }
}
