package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.api.MojoTransformationGroup;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import java.util.Arrays;

/**
 * Representation of one transformation operation in the pipeline.
 */
public abstract class MojoTransform {

    public final int[] iindices;
    public final int[] oindices;
    public final MojoFrameMeta meta;
    private String id;
    private String name;
    private MojoTransformationGroup transformationGroup;

    public MojoTransform(MojoFrameMeta meta, int[] iindices, int[] oindices) {
        assert iindices != null;
        assert oindices != null;
        this.meta = meta;
        this.iindices = iindices;
        this.oindices = oindices;
    }

    public MojoColumn.Type[] getInputTypes() {
        MojoColumn.Type[] types = new MojoColumn.Type[iindices.length];
        for (int i = 0; i < types.length; i += 1) {
            types[i] = meta.getColumnType(iindices[i]);
        }
        return types;
    }

    public MojoColumn.Type getInputType(int idx) {
        return meta.getColumnType(iindices[idx]);
    }

    public MojoColumn.Type[] getOutputTypes() {
        MojoColumn.Type[] types = new MojoColumn.Type[oindices.length];
        for (int i = 0; i < types.length; i += 1) {
            types[i] = meta.getColumnType(oindices[i]);
        }
        return types;
    }

    public MojoColumn.Type getOutputType(int idx) {
        return meta.getColumnType(oindices[idx]);
    }

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public MojoTransformationGroup getTransformationGroup() {
        return transformationGroup;
    }

    public void setTransformationGroup(final MojoTransformationGroup transformationGroup) {
        this.transformationGroup = transformationGroup;
    }

    public String getName() {
        return name;
    }

    public void setName(final String name) {
        this.name = name;
    }

    public abstract void transform(MojoFrame frame);

    @Override
    public String toString() {
        return String.format("%s:%s:%s->%s", id, getName(), Arrays.toString(iindices), Arrays.toString(oindices));
    }
}
