package ai.h2o.mojos.runtime.utils;

public class ParserUtils {

    /**
     * Trim leading and ending ' '.
     *
     * @param s  input string
     * @return modified string if it contains leading or ending whitespaces
     *         or original string.
     */
    public static String trimSpace(String s) {
        int len = s.length();
        int start = 0;

        while ((start < len) && (s.charAt(start) == ' ')) {
            start++;
        }
        while ((start < len) && (s.charAt(len-1) == ' ')) {
            len--;
        }
        return ((start > 0) || (len < s.length())) ? s.substring(start, len) : s;
    }
}
