package ai.h2o.mojos.runtime.api.backend;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

/**
 * Basic information about a resource in {@link ReaderBackend}.
 */
public final class ResourceInfo {
    public final long size;
    public final String weakHash;

    public ResourceInfo(final long size, final String weakHash) {
        this.size = size;
        this.weakHash = weakHash;
    }

    public static String computeMD5(final byte[] bytes) throws NoSuchAlgorithmException {
        final MessageDigest m = MessageDigest.getInstance("MD5");
        m.update(bytes,0, bytes.length);
        final BigInteger i = new BigInteger(1,m.digest());
        return String.format("%1$032X", i);
    }

    static class Cache extends HashMap<String, ResourceInfo> {}
}
