package ai.h2o.mojos.runtime.utils;

import java.util.Base64;

/**
 * Helper class for Base64 operations.
 */
public class Base64Utils {

    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final Base64.Decoder DECODER_URL = Base64.getUrlDecoder();
    private static final Base64.Encoder ENCODER = Base64.getEncoder();

    public static byte[] encode(byte[] src) {
        return ENCODER.encode(src);
    }

    public static byte[] decode(byte[] src) {
        return DECODER.decode(src);
    }

    public static byte[] decodeUrl(byte[] src) {
        return DECODER_URL.decode(src);
    }

    public static byte[] decodeUrl(String src) {
        return !isEmpty(src) ? decodeUrl(src.getBytes()) : null;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}
