package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.transforms.MojoTransform;

/**
 * Temporary representation of a transformer - before it is fully loaded.
 */
public class MojoTransformMeta extends MojoTransform {
    private final Object desc;
    private final int transformationIndex;
    private MojoTransform transform;

    /**
     * WARNING: Do not use this constructor.
     * Only for internal use of mojo2 implementation.
     * Subject to change without notice.
     */
    public MojoTransformMeta(String name, Object desc, int[] iindices, int[] oindices, final String id, int transformationIndex, final MojoTransformationGroup transformationGroup) {
        super(iindices, oindices);
        this.desc = desc;
        this.transformationIndex = transformationIndex;
        this.setName(name);
        this.setId(id);
        this.setTransformationGroup(transformationGroup);
    }

    /**
     * Only for internal use - subject to change without notice
     */
    public MojoTransform getTransform() {
        return transform;
    }

    /**
     * Only for internal use - subject to change without notice
     */
    public void setTransform(MojoTransform transform) {
        this.transform = transform;
    }

    /**
     * Description, can be multi-line.
     * @return object whose {@link #toString()} has the description
     */
    public Object getDesc() {
        return desc;
    }

    public int[] getInputIndices() {
        if (transform != null) {
            // may differ when there featureMap is applied
            return transform.iindices;
        }
        return iindices;
    }

    public int[] getOutputIndices() {
        return oindices;
    }

    /**
     * @return index of transformation operation in the pipeline, before removing unused part
     */
    public int getTransformationIndex() {
        return transformationIndex;
    }

    @Override
    public void transform(final MojoFrame frame) {
        throw new UnsupportedOperationException("This is not meant to perform any operation");
    }

    @Override
    public String toString() {
        return "{{" + super.toString() + "}}";
    }
}
