package ai.h2o.mojos.runtime.utils;

public class Consts {

  /** Prefix for system configuration variables */
  public static final String SYS_PROP_PREFIX = "sys.ai.h2o.mojos.";

  public static String prop(String suffix) {
    return SYS_PROP_PREFIX + suffix;
  }

  public static boolean propExist(String suffix) {
    return System.getProperty(prop(suffix)) != null;
  }

  public static String getSysProp(String suffix, String defaultValue) {
    return System.getProperty(prop(suffix), defaultValue);
  }

  public static boolean getSysProp(String suffix, boolean defaultValue) {
    return Boolean.valueOf(System.getProperty(prop(suffix), Boolean.toString(defaultValue)));
  }

  public static byte getSysProp(String suffix, byte defaultValue) {
    return Byte.valueOf(System.getProperty(prop(suffix), Byte.toString(defaultValue)));
  }

  public static int getSysProp(String suffix, int defaultValue) {
    return Integer.valueOf(System.getProperty(prop(suffix), Integer.toString(defaultValue)));
  }

  public static long getSysProp(String suffix, long defaultValue) {
    return Long.valueOf(System.getProperty(prop(suffix), Long.toString(defaultValue)));
  }
}
