package ai.h2o.mojos.runtime.utils;

public class ClassLoaderUtils {

  public static final String PROP_USE_CONTEXT_CLASSLOADER_FOR_SPI = "runtime.useContextClassloaderForSpi";

  public static final String PROP_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST = "runtime.useContextClassloaderForJavassist";

  public static final boolean DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_SPI = false;

  public static final boolean DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST = false;

  static boolean getPropUseContextClassloaderForSpi() {
    return Consts.getSysProp(PROP_USE_CONTEXT_CLASSLOADER_FOR_SPI,
                             DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_SPI);
  }

  static boolean getPropUseContextClassloaderForJavassist() {
    return Consts.getSysProp(PROP_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST,
                             DEFAULT_USE_CONTEXT_CLASSLOADER_FOR_JAVASSIST);
  }

  public static ClassLoader getPreferredSpiClassLoader(Class<?> usedClass) {
    ClassLoader cl = ClassLoaderUtils.getPropUseContextClassloaderForSpi()
                     ? Thread.currentThread().getContextClassLoader()
                     : usedClass.getClassLoader();
    return cl;
  }

  public static ClassLoader getPreferredJavassistClassLoader(Class<?> usedClass) {
    ClassLoader cl = ClassLoaderUtils.getPropUseContextClassloaderForJavassist()
                     ? Thread.currentThread().getContextClassLoader()
                     : usedClass.getClassLoader();
    return cl;
  }
}
