/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.ArrayList;
import java.util.List;

public class MojoColumnMeta {
    private final String columnName;
    private final MojoColumn.Type columnType;

    private MojoColumnMeta(String columnName, MojoColumn.Type columnType) {
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public static MojoColumnMeta create(String columnName, MojoColumn.Type columnType) {
        return new MojoColumnMeta(columnName, columnType);
    }

    @Deprecated
    public static MojoColumnMeta newInput(String columnName, MojoColumn.Type columnType) {
        return MojoColumnMeta.create(columnName, columnType);
    }

    @Deprecated
    public static MojoColumnMeta newOutput(String name, MojoColumn.Type columnType) {
        return MojoColumnMeta.create(name, columnType);
    }

    public static List<MojoColumnMeta> toColumns(String[] columnNames, MojoColumn.Type[] columnTypes) {
        if (columnNames.length != columnTypes.length) {
            throw new IllegalArgumentException("columnNames and columnTypes arguments must have the same length");
        }
        ArrayList<MojoColumnMeta> cols = new ArrayList<MojoColumnMeta>();
        for (int i = 0; i < columnNames.length; ++i) {
            MojoColumnMeta col = MojoColumnMeta.create(columnNames[i], columnTypes[i]);
            cols.add(col);
        }
        return cols;
    }

    @Deprecated
    public static List<MojoColumnMeta> toColumns(String[] columnNames, MojoColumn.Type[] columnTypes, MojoColumn.Kind kind_ignored) {
        return MojoColumnMeta.toColumns(columnNames, columnTypes);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public MojoColumn.Type getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return this.columnName + ":" + (Object)((Object)this.columnType);
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

