/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFloat64;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.utils.Debug;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.KLimeModelPrediction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.joda.time.DateTime;

public class MojoPipelineKlimeImpl
extends MojoPipeline {
    private final EasyPredictModelWrapper _model;
    private final GenModel genModel;
    private final MojoFrameMeta _inputMeta;
    private final MojoFrameMeta _outputMeta;

    MojoPipelineKlimeImpl(MojoModel model) {
        super(model.getUUID(), new DateTime(1970, 1, 1, 0, 0), "");
        this._model = MojoPipelineKlimeImpl.wrapModelForPrediction(model);
        this.genModel = this._model.m;
        String[] inames = new String[this.genModel.getNumCols()];
        MojoColumn.Type[] itypes = new MojoColumn.Type[inames.length];
        for (int i = 0; i < inames.length; ++i) {
            inames[i] = this.genModel.getNames()[i];
            itypes[i] = this.genModel.getDomainValues(i) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
        }
        this._inputMeta = new MojoFrameMeta(inames, itypes);
        String[] onames = new String[this.genModel.getPredsSize()];
        MojoColumn.Type[] otypes = new MojoColumn.Type[onames.length];
        String[] predictors = this.genModel.getNames();
        ArrayList<String> mypredictorsList = new ArrayList<String>(Arrays.asList(predictors));
        mypredictorsList.remove(this.genModel.getResponseName());
        predictors = mypredictorsList.toArray(new String[0]);
        onames[0] = this.genModel.getResponseName();
        otypes[0] = MojoColumn.Type.Float64;
        onames[1] = "cluster";
        otypes[1] = MojoColumn.Type.Float64;
        for (int i = 2; i < onames.length; ++i) {
            onames[i] = predictors[i - 2];
            otypes[i] = MojoColumn.Type.Float64;
        }
        this._outputMeta = new MojoFrameMeta(onames, otypes);
    }

    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Collections.emptyList(), Collections.emptyMap());
    }

    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                return this._inputMeta;
            }
            case Output: {
                return this._outputMeta;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        ModelCategory modelCategory = this.genModel.getModelCategory();
        int colCount = inputFrame.getNcols();
        int rowCount = inputFrame.getNrows();
        String[] columnNames = inputFrame.getColumnNames();
        String[][] columns = new String[colCount][];
        for (int j = 0; j < colCount; ++j) {
            columns[j] = inputFrame.getColumn(j).getDataAsStrings();
        }
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            RowData rowData = new RowData();
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                String key = columnNames[colIdx];
                String value = columns[colIdx][rowIdx];
                if (value == null) continue;
                rowData.put((Object)key, (Object)value);
            }
            try {
                KLimeModelPrediction p = this._model.predictKLime(rowData);
                block10: for (int outputColIdx = 0; outputColIdx < this.genModel.getPredsSize(); ++outputColIdx) {
                    MojoColumnFloat64 col = (MojoColumnFloat64)outputFrame.getColumn(outputColIdx);
                    double[] darr = (double[])col.getData();
                    switch (outputColIdx) {
                        case 0: {
                            darr[rowIdx] = p.value;
                            continue block10;
                        }
                        case 1: {
                            darr[rowIdx] = p.cluster;
                            continue block10;
                        }
                        default: {
                            darr[rowIdx] = p.reasonCodes[outputColIdx - 2];
                        }
                    }
                }
                continue;
            }
            catch (PredictException e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed: %s", modelCategory, e.getMessage()));
            }
            catch (Exception e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed with %s: %s", modelCategory, e.getClass().getName(), e.getMessage()));
            }
        }
        return outputFrame;
    }

    private static EasyPredictModelWrapper wrapModelForPrediction(MojoModel model) {
        EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel((GenModel)model).setConvertUnknownCategoricalLevelsToNa(true).setConvertInvalidNumbersToNa(true);
        return new EasyPredictModelWrapper(config){

            protected double[] preamble(ModelCategory c, RowData data) throws PredictException {
                assert (c == ModelCategory.KLime) : "Unexpected model category, should be K-Lime! If you upgraded h2o-genmodel runtime,please check https://0xdata.atlassian.net/browse/PUBDEV-7627 and remove this override of the `preamble` method";
                return this.preamble(ModelCategory.Regression, data, 0.0);
            }
        };
    }
}

