/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.h2o3.H2O3BackendAdapter;
import ai.h2o.mojos.runtime.h2o3.H2O3Transform;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformBuilder;
import ai.h2o.mojos.runtime.utils.ArrayReaderUtils;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

class H2O3PipelineLoader
extends AbstractPipelineLoader {
    private final MojoPipelineMeta pipelineMeta;

    public H2O3PipelineLoader(ReaderBackend backend) throws IOException {
        super(backend);
        H2O3BackendAdapter mojoReader = new H2O3BackendAdapter(backend);
        MojoModel model = MojoModel.load((MojoReaderBackend)mojoReader);
        EasyPredictModelWrapper easyPredictModelWrapper = H2O3PipelineLoader.wrapModelForPrediction(model);
        String name = "h2o3:" + model.getModelCategory().toString();
        ArrayList<MojoColumnMeta> columns = new ArrayList<MojoColumnMeta>();
        int[] inputIndices = H2O3PipelineLoader.readInputIndices(columns, (GenModel)model);
        int[] outputIndices = H2O3PipelineLoader.readOutputIndices(columns, (GenModel)model);
        MojoFrameMeta meta = new MojoFrameMeta(columns);
        String desc = String.format("algo: %s, balanceClasses: %s, attributes: %s, default threshold: %s", model._algoName, model._balanceClasses, model._modelAttributes, model._defaultThreshold);
        MojoTransformMeta mtm = new MojoTransformMeta(name, (Object)desc, inputIndices, outputIndices, 0, null);
        final H2O3Transform transform = new H2O3Transform(easyPredictModelWrapper, inputIndices, outputIndices);
        mtm.setTransformBuilder(new MojoTransformBuilder(meta, inputIndices, outputIndices){

            public MojoTransform build() {
                return transform;
            }
        });
        mtm.setTransform((MojoTransform)transform);
        DateTime creationTime = new DateTime(1970, 1, 1, 0, 0);
        this.pipelineMeta = new MojoPipelineMeta(Collections.singletonList(mtm), meta, true, ArrayReaderUtils.fromArrayToList((int[])inputIndices), ArrayReaderUtils.fromArrayToList((int[])outputIndices), model.getUUID(), creationTime);
        this.pipelineMeta.license = "H2O-3 Opensource";
    }

    static int[] readInputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        int[] inputIndices = new int[genModel.getNumCols()];
        for (int i = 0; i < genModel.getNumCols(); ++i) {
            String columnName = genModel.getNames()[i];
            MojoColumn.Type columnType = genModel.getDomainValues(i) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            inputIndices[i] = columns.size();
            columns.add(MojoColumnMeta.newInput((String)columnName, (MojoColumn.Type)columnType));
        }
        return inputIndices;
    }

    private static int[] readOutputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        switch (genModel.getModelCategory()) {
            case Binomial: 
            case Multinomial: {
                int[] outputIndices = new int[genModel.getNumResponseClasses()];
                for (int i = 0; i < genModel.getNumResponseClasses(); ++i) {
                    String columnName = genModel.getResponseName() + "." + genModel.getDomainValues(genModel.getResponseIdx())[i];
                    outputIndices[i] = columns.size();
                    columns.add(MojoColumnMeta.newOutput((String)columnName, (MojoColumn.Type)MojoColumn.Type.Float64));
                }
                return outputIndices;
            }
            case Regression: {
                MojoColumnMeta column = MojoColumnMeta.newOutput((String)genModel.getResponseName(), (MojoColumn.Type)MojoColumn.Type.Float64);
                int[] outputIndices = new int[]{columns.size()};
                columns.add(column);
                return outputIndices;
            }
        }
        throw new UnsupportedOperationException("Unsupported ModelCategory: " + genModel.getModelCategory().toString());
    }

    public List<MojoColumnMeta> getColumns() {
        return this.pipelineMeta.getColumns();
    }

    public List<MojoTransformMeta> getTransformations() {
        return this.pipelineMeta.transforms;
    }

    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(this.pipelineMeta);
    }

    static EasyPredictModelWrapper wrapModelForPrediction(MojoModel model) {
        EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel((GenModel)model).setConvertUnknownCategoricalLevelsToNa(true).setConvertInvalidNumbersToNa(true);
        return new EasyPredictModelWrapper(config);
    }
}

