/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.frame.MojoColumnFloat64;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.Debug;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.BinomialModelPrediction;

public class H2O3Transform
implements MojoTransform {
    private final GenModel genModel;
    private final EasyPredictModelWrapper easyPredictModelWrapper;
    private final int[] inputIndices;
    private final int[] outputIndices;

    H2O3Transform(EasyPredictModelWrapper easyPredictModelWrapper, int[] inputIndices, int[] outputIndices) {
        this.easyPredictModelWrapper = easyPredictModelWrapper;
        this.genModel = easyPredictModelWrapper.m;
        this.inputIndices = inputIndices;
        this.outputIndices = outputIndices;
    }

    public void transform(MojoFrame frame) {
        ModelCategory modelCategory = this.genModel.getModelCategory();
        int colCount = this.inputIndices.length;
        int rowCount = frame.getNrows();
        String[][] columns = new String[colCount][];
        for (int j = 0; j < colCount; ++j) {
            int iidx = this.inputIndices[j];
            columns[j] = frame.getColumn(iidx).getDataAsStrings();
        }
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            RowData rowData = new RowData();
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                int iidx = this.inputIndices[colIdx];
                String key = frame.getColumnName(iidx);
                String value = columns[colIdx][rowIdx];
                if (value == null) continue;
                rowData.put((Object)key, (Object)value);
            }
            try {
                switch (modelCategory) {
                    case Binomial: {
                        BinomialModelPrediction p = this.easyPredictModelWrapper.predictBinomial(rowData);
                        this.setPrediction(frame, rowIdx, p.classProbabilities);
                        break;
                    }
                    case Multinomial: {
                        BinomialModelPrediction p = this.easyPredictModelWrapper.predictMultinomial(rowData);
                        this.setPrediction(frame, rowIdx, p.classProbabilities);
                        break;
                    }
                    case Regression: {
                        BinomialModelPrediction p = this.easyPredictModelWrapper.predictRegression(rowData);
                        MojoColumnFloat64 col = (MojoColumnFloat64)frame.getColumn(this.outputIndices[0]);
                        double[] darr = (double[])col.getData();
                        darr[rowIdx] = p.value;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported ModelCategory: " + modelCategory.toString());
                    }
                }
                continue;
            }
            catch (UnsupportedOperationException e) {
                throw e;
            }
            catch (PredictException e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed: %s", modelCategory, e.getMessage()));
            }
            catch (Exception e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed with %s: %s", modelCategory, e.getClass().getName(), e.getMessage()));
            }
        }
    }

    private void setPrediction(MojoFrame frame, int rowIdx, double[] classProbabilities) {
        for (int outputColIdx = 0; outputColIdx < this.outputIndices.length; ++outputColIdx) {
            int oidx = this.outputIndices[outputColIdx];
            MojoColumnFloat64 col = (MojoColumnFloat64)frame.getColumn(oidx);
            double[] darr = (double[])col.getData();
            darr[rowIdx] = classProbabilities[outputColIdx];
        }
    }
}

