/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.PipelineConfig;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.h2o3.H2O3BackendAdapter;
import ai.h2o.mojos.runtime.h2o3.H2O3Transform;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;

class H2O3PipelineLoader
extends AbstractPipelineLoader {
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;

    public H2O3PipelineLoader(ReaderBackend backend, PipelineConfig config) throws IOException {
        super(backend, config);
        H2O3BackendAdapter mojoReader = new H2O3BackendAdapter(backend);
        MojoModel model = MojoModel.load((MojoReaderBackend)mojoReader);
        EasyPredictModelWrapper easyPredictModelWrapper = H2O3PipelineLoader.wrapModelForPrediction(model);
        String name = "h2o3:" + model.getModelCategory().toString();
        this.globalColumns = new ArrayList<MojoColumnMeta>();
        int[] inputIndices = H2O3PipelineLoader.readInputIndices(this.globalColumns, (GenModel)model);
        int[] outputIndices = H2O3PipelineLoader.readOutputIndices(this.globalColumns, (GenModel)model);
        MojoFrameMeta globalMeta = new MojoFrameMeta(this.globalColumns);
        H2O3Transform transform = new H2O3Transform(globalMeta, inputIndices, outputIndices, easyPredictModelWrapper);
        transform.setId("h2o3-main");
        transform.setName(name);
        DateTime creationTime = new DateTime(1970, 1, 1, 0, 0);
        MojoPipelineMeta pipelineMeta = new MojoPipelineMeta(model.getUUID(), creationTime);
        pipelineMeta.license = "H2O-3 Opensource";
        this.root = new MojoTransformExecPipeBuilder(inputIndices, outputIndices, (MojoTransform)transform, pipelineMeta);
        this.root.transforms.add(transform);
    }

    static int[] readInputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        int[] inputIndices = new int[genModel.getNumCols()];
        for (int i = 0; i < genModel.getNumCols(); ++i) {
            String columnName = genModel.getNames()[i];
            MojoColumn.Type columnType = genModel.getDomainValues(i) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            inputIndices[i] = columns.size();
            columns.add(MojoColumnMeta.create((String)columnName, (MojoColumn.Type)columnType));
        }
        return inputIndices;
    }

    private static int[] readOutputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        switch (genModel.getModelCategory()) {
            case Binomial: 
            case Multinomial: {
                int[] outputIndices = new int[genModel.getNumResponseClasses()];
                for (int i = 0; i < genModel.getNumResponseClasses(); ++i) {
                    String columnName = genModel.getResponseName() + "." + genModel.getDomainValues(genModel.getResponseIdx())[i];
                    outputIndices[i] = columns.size();
                    columns.add(MojoColumnMeta.create((String)columnName, (MojoColumn.Type)MojoColumn.Type.Float64));
                }
                return outputIndices;
            }
            case Regression: {
                MojoColumnMeta column = MojoColumnMeta.create((String)genModel.getResponseName(), (MojoColumn.Type)MojoColumn.Type.Float64);
                int[] outputIndices = new int[]{columns.size()};
                columns.add(column);
                return outputIndices;
            }
        }
        throw new UnsupportedOperationException("Unsupported ModelCategory: " + genModel.getModelCategory().toString());
    }

    public List<MojoColumnMeta> getColumns() {
        return this.globalColumns;
    }

    public List<MojoTransformMeta> getTransformations() {
        return this.root.metaTransforms;
    }

    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(this.globalColumns, this.root, this.config);
    }

    static EasyPredictModelWrapper wrapModelForPrediction(MojoModel model) {
        EasyPredictModelWrapper.Config config = new EasyPredictModelWrapper.Config().setModel((GenModel)model).setConvertUnknownCategoricalLevelsToNa(true).setConvertInvalidNumbersToNa(true);
        return new EasyPredictModelWrapper(config);
    }
}

