/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.frame.MojoColumnFloat64;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.Debug;
import hex.ModelCategory;
import hex.genmodel.GenModel;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.KLimeModelPrediction;

public class KlimeTransform
extends MojoTransform {
    private final EasyPredictModelWrapper easyPredictModelWrapper;
    private final GenModel genModel;

    KlimeTransform(MojoFrameMeta meta, int[] iindices, int[] oindices, EasyPredictModelWrapper easyPredictModelWrapper) {
        super(iindices, oindices);
        this.easyPredictModelWrapper = easyPredictModelWrapper;
        this.genModel = easyPredictModelWrapper.m;
    }

    public void transform(MojoFrame frame) {
        ModelCategory modelCategory = this.genModel.getModelCategory();
        int colCount = this.iindices.length;
        int rowCount = frame.getNrows();
        String[][] columns = new String[colCount][];
        for (int j = 0; j < colCount; ++j) {
            int iidx = this.iindices[j];
            columns[j] = frame.getColumn(iidx).getDataAsStrings();
        }
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            RowData rowData = new RowData();
            for (int colIdx = 0; colIdx < colCount; ++colIdx) {
                int iidx = this.iindices[colIdx];
                String key = frame.getColumnName(iidx);
                String value = columns[colIdx][rowIdx];
                if (value == null) continue;
                rowData.put((Object)key, (Object)value);
            }
            try {
                KLimeModelPrediction p = this.easyPredictModelWrapper.predictKLime(rowData);
                block10: for (int outputColIdx = 0; outputColIdx < this.genModel.getPredsSize(); ++outputColIdx) {
                    MojoColumnFloat64 col = (MojoColumnFloat64)frame.getColumn(this.oindices[outputColIdx]);
                    double[] darr = (double[])col.getData();
                    switch (outputColIdx) {
                        case 0: {
                            darr[rowIdx] = p.value;
                            continue block10;
                        }
                        case 1: {
                            darr[rowIdx] = p.cluster;
                            continue block10;
                        }
                        default: {
                            darr[rowIdx] = p.reasonCodes[outputColIdx - 2];
                        }
                    }
                }
                continue;
            }
            catch (PredictException e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed: %s", modelCategory, e.getMessage()));
            }
            catch (Exception e) {
                if (Debug.getPrintH2O3Exceptions()) {
                    e.printStackTrace();
                }
                throw new UnsupportedOperationException(String.format("%s failed with %s: %s", modelCategory, e.getClass().getName(), e.getMessage()));
            }
        }
    }
}

