/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.h2o3;

import ai.h2o.mojos.runtime.AbstractPipelineLoader;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.MojoPipelineMeta;
import ai.h2o.mojos.runtime.MojoPipelineProtoImpl;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.MojoTransformMeta;
import ai.h2o.mojos.runtime.api.PipelineConfig;
import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.h2o3.H2O3BackendAdapter;
import ai.h2o.mojos.runtime.h2o3.H2O3PipelineLoader;
import ai.h2o.mojos.runtime.h2o3.KlimeTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import hex.genmodel.GenModel;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.easy.EasyPredictModelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;

class KLimePipelineLoader
extends AbstractPipelineLoader {
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;

    public KLimePipelineLoader(ReaderBackend backend, PipelineConfig config) throws IOException {
        super(backend, config);
        H2O3BackendAdapter mojoReader = new H2O3BackendAdapter(backend);
        MojoModel model = MojoModel.load((MojoReaderBackend)mojoReader);
        EasyPredictModelWrapper easyPredictModelWrapper = H2O3PipelineLoader.wrapModelForPrediction(model, config.isShapEnabled());
        String name = "klime:" + model.getModelCategory().toString();
        this.globalColumns = new ArrayList<MojoColumnMeta>();
        int[] inputIndices = KLimePipelineLoader.readInputIndices(this.globalColumns, (GenModel)model);
        int[] outputIndices = KLimePipelineLoader.readOutputIndices(this.globalColumns, (GenModel)model);
        MojoFrameMeta globalMeta = new MojoFrameMeta(this.globalColumns);
        KlimeTransform transform = new KlimeTransform(globalMeta, inputIndices, outputIndices, easyPredictModelWrapper);
        transform.setId("klime-main");
        transform.setName(name);
        DateTime creationTime = new DateTime(1970, 1, 1, 0, 0);
        MojoPipelineMeta pipelineMeta = new MojoPipelineMeta(model.getUUID(), creationTime);
        pipelineMeta.license = "H2O-3 Opensource";
        this.root = new MojoTransformExecPipeBuilder(inputIndices, outputIndices, (MojoTransform)transform, pipelineMeta);
        this.root.transforms.add(transform);
    }

    public List<MojoColumnMeta> getColumns() {
        return this.globalColumns;
    }

    public List<MojoTransformMeta> getTransformations() {
        return this.root.metaTransforms;
    }

    protected final MojoPipeline internalLoad() {
        return new MojoPipelineProtoImpl(this.globalColumns, this.root, PipelineConfig.DEFAULT);
    }

    static int[] readInputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        int[] inputIndices = new int[genModel.getNumCols()];
        for (int i = 0; i < genModel.getNumCols(); ++i) {
            String columnName = genModel.getNames()[i];
            MojoColumn.Type columnType = genModel.getDomainValues(i) == null ? MojoColumn.Type.Float64 : MojoColumn.Type.Str;
            inputIndices[i] = columns.size();
            columns.add(MojoColumnMeta.create((String)columnName, (MojoColumn.Type)columnType));
        }
        return inputIndices;
    }

    private static int[] readOutputIndices(List<MojoColumnMeta> columns, GenModel genModel) {
        ArrayList<String> mypredictorsList = new ArrayList<String>(Arrays.asList(genModel.getNames()));
        mypredictorsList.remove(genModel.getResponseName());
        String[] predictors = mypredictorsList.toArray(new String[0]);
        int predsSize = genModel.getPredsSize();
        int[] outputIndices = new int[predsSize];
        outputIndices[0] = columns.size();
        columns.add(MojoColumnMeta.create((String)genModel.getResponseName(), (MojoColumn.Type)MojoColumn.Type.Float64));
        outputIndices[1] = columns.size();
        columns.add(MojoColumnMeta.create((String)"cluster", (MojoColumn.Type)MojoColumn.Type.Float64));
        for (int i = 2; i < predsSize; ++i) {
            outputIndices[i] = columns.size();
            String outputColumnName = "rc_" + predictors[i - 2];
            columns.add(MojoColumnMeta.create((String)outputColumnName, (MojoColumn.Type)MojoColumn.Type.Float64));
        }
        return outputIndices;
    }
}

