/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.lic.LicenseException;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import ai.h2o.mojos.runtime.utils.CsvWritingBatchHandler;
import ai.h2o.mojos.runtime.utils.StopWatch;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;

public class ExecuteMojo {
    private static final String STDIN_FILENAME = "-";
    static final String USAGE = "Usage:\n  java -cp mojo2-runtime.jar ai.h2o.mojos.ExecuteMojo <path to .mojo file> <path to .csv file> [<path to write output csv>]\n\nExamples:\n  java -cp mojo2-runtime.jar ai.h2o.mojos.ExecuteMojo pipeline.mojo example.csv\n    * Transforms data from the file example.csv using MOJO stored in the file pipeline.mojo\n\n  cat example.csv | java -cp mojo2-runtime.jar ai.h2o.mojos.ExecuteMojo pipeline.mojo -\n    * Transforms data from the pipe using MOJO stored in the file pipeline.mojo";

    static void usage() {
        System.out.println(USAGE);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2 || args.length > 3) {
            ExecuteMojo.usage();
            System.exit(-1);
        }
        try {
            StopWatch stopWatch = StopWatch.start();
            MojoPipeline mojoPipeline = MojoPipeline.loadFrom((String)args[0]);
            System.err.println("Mojo load time: " + stopWatch.lapStr());
            String string = args[1];
            String string2 = args.length == 3 ? args[2] : STDIN_FILENAME;
            OutputStreamWriter outputStreamWriter = string2.equals(STDIN_FILENAME) ? new OutputStreamWriter(System.out) : new FileWriter(string2);
            BatchedCsvMojoProcessor batchedCsvMojoProcessor = new BatchedCsvMojoProcessor(mojoPipeline);
            InputStreamReader inputStreamReader = string.equals(STDIN_FILENAME) ? new InputStreamReader(System.in) : new FileReader(string);
            Throwable throwable = null;
            try {
                CsvWritingBatchHandler csvWritingBatchHandler = new CsvWritingBatchHandler(outputStreamWriter);
                Throwable throwable2 = null;
                try {
                    String string3 = Consts.getSysProp((String)"exposedInputs", null);
                    if (string3 != null) {
                        if (string3.equals("ALL")) {
                            csvWritingBatchHandler.setExposeAllInputs(true);
                        } else {
                            csvWritingBatchHandler.setExposedInputs(string3.split(","));
                        }
                    }
                    batchedCsvMojoProcessor.processCsv((Reader)inputStreamReader, csvWritingBatchHandler);
                }
                catch (Throwable throwable3) {
                    try {
                        Throwable throwable4 = throwable3;
                        throwable2 = throwable3;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 != null) {
                            try {
                                csvWritingBatchHandler.close();
                            }
                            catch (Throwable throwable6) {
                                throwable2.addSuppressed(throwable6);
                            }
                        } else {
                            csvWritingBatchHandler.close();
                        }
                        throw throwable5;
                    }
                }
                csvWritingBatchHandler.close();
            }
            catch (Throwable throwable7) {
                try {
                    Throwable throwable8 = throwable7;
                    throwable = throwable7;
                    throw throwable8;
                }
                catch (Throwable throwable9) {
                    if (throwable != null) {
                        try {
                            ((Reader)inputStreamReader).close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        ((Reader)inputStreamReader).close();
                    }
                    throw throwable9;
                }
            }
            ((Reader)inputStreamReader).close();
        }
        catch (LicenseException licenseException) {
            System.err.println(licenseException.getMessage());
            System.exit(-1);
        }
    }
}

