/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryImpl;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.StringConverter;
import ai.h2o.mojos.runtime.frame.StringToDateConverter;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.DateParser;
import ai.h2o.mojos.runtime.utils.MojoDateTimeParserFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;

public class MojoPipelineProtoImpl
extends MojoPipeline {
    private final MojoFrameMeta globalFrameMeta;
    private final MojoFrameMeta inputFrameMeta;
    private final MojoFrameMeta outputFrameMeta;
    private final MojoTransform[] transforms;
    private final MojoPipelineMeta pipelineMetainfo;
    private final Map<String, StringConverter> dateTimeConverters = new HashMap<String, StringConverter>(0);

    public MojoPipelineProtoImpl(MojoTransform[] transforms, MojoPipelineMeta pipelineMetainfo) {
        super(pipelineMetainfo.uuid, pipelineMetainfo.creationTime, pipelineMetainfo.license);
        this.globalFrameMeta = pipelineMetainfo.globalMeta;
        this.inputFrameMeta = pipelineMetainfo.createInputMeta();
        this.outputFrameMeta = pipelineMetainfo.createOutputMeta();
        this.transforms = transforms;
        this.pipelineMetainfo = pipelineMetainfo;
        if (pipelineMetainfo.datetimeStringFormats != null) {
            for (Map.Entry<String, String> entry : pipelineMetainfo.datetimeStringFormats.entrySet()) {
                DateParser dateParser = new DateParser(MojoDateTimeParserFactory.forPattern(entry.getValue()));
                this.dateTimeConverters.put(entry.getKey(), new StringToDateConverter(dateParser));
            }
        }
    }

    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Arrays.asList(this.pipelineMetainfo.missingValues), this.dateTimeConverters);
    }

    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                return this.inputFrameMeta;
            }
            case Output: {
                return this.outputFrameMeta;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        int n2;
        MojoColumn[] mojoColumnArray = new MojoColumn[this.globalFrameMeta.size()];
        int n3 = inputFrame.getNrows();
        MojoColumnFactoryImpl mojoColumnFactoryImpl = new MojoColumnFactoryImpl();
        int[] nArray = this.pipelineMetainfo.inputIndices;
        assert (inputFrame.getNcols() == nArray.length);
        int[] nArray2 = this.pipelineMetainfo.outputIndices;
        assert (outputFrame.getNcols() == nArray2.length);
        for (n2 = 0; n2 < nArray.length; ++n2) {
            mojoColumnArray[nArray[n2]] = inputFrame.getColumn(n2);
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            mojoColumnArray[nArray2[n2]] = outputFrame.getColumn(n2);
        }
        for (n2 = 0; n2 < mojoColumnArray.length; ++n2) {
            if (mojoColumnArray[n2] != null) continue;
            mojoColumnArray[n2] = mojoColumnFactoryImpl.create(this.globalFrameMeta.getColumnType(n2), n3);
        }
        MojoFrame mojoFrame = MojoFrameBuilder.fromColumns((MojoFrameMeta)this.globalFrameMeta, (MojoColumn[])mojoColumnArray);
        MojoTransform[] mojoTransformArray = this.transforms;
        int n4 = this.transforms.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            MojoTransform mojoTransform = mojoTransformArray[i2];
            mojoTransform.transform(mojoFrame);
        }
        return outputFrame;
    }

    public static class MojoPipelineMeta {
        public MojoFrameMeta globalMeta;
        public int[] inputIndices;
        public int[] outputIndices;
        public String uuid;
        public DateTime creationTime;
        public String license;
        public String[] missingValues;
        public Map<String, String> datetimeStringFormats;

        public MojoFrameMeta createInputMeta() {
            String[] stringArray = new String[this.inputIndices.length];
            MojoColumn.Type[] typeArray = new MojoColumn.Type[this.inputIndices.length];
            for (int i2 = 0; i2 < this.inputIndices.length; ++i2) {
                int n2 = this.inputIndices[i2];
                stringArray[i2] = this.globalMeta.getColumnName(n2);
                typeArray[i2] = this.globalMeta.getColumnType(n2);
            }
            return new MojoFrameMeta(stringArray, typeArray);
        }

        public MojoFrameMeta createOutputMeta() {
            String[] stringArray = new String[this.outputIndices.length];
            MojoColumn.Type[] typeArray = new MojoColumn.Type[this.outputIndices.length];
            for (int i2 = 0; i2 < this.outputIndices.length; ++i2) {
                int n2 = this.outputIndices[i2];
                stringArray[i2] = this.globalMeta.getColumnName(n2);
                typeArray[i2] = this.globalMeta.getColumnType(n2);
            }
            return new MojoFrameMeta(stringArray, typeArray);
        }
    }
}

