/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MojoColumnInt64
extends MojoColumn {
    private long[] _data;

    MojoColumnInt64(int nrows) {
        this._data = new long[nrows];
    }

    public String debug() {
        return Arrays.toString(this._data);
    }

    public MojoColumn.Type getType() {
        return MojoColumn.Type.Int64;
    }

    public Object getData() {
        return this._data;
    }

    public String[] getDataAsStrings() {
        String[] stringArray = new String[this._data.length];
        for (int i2 = 0; i2 < this._data.length; ++i2) {
            stringArray[i2] = this._data[i2] == Long.MIN_VALUE ? null : Long.toString(this._data[i2]);
        }
        return stringArray;
    }

    public int size() {
        return this._data.length;
    }

    void resize(int n2) {
        if (this._data.length != n2) {
            this._data = new long[n2];
        }
    }

    void fillFromCsvData(String[][] fields, int col) {
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String string = fields[i2][col];
            this._data[i2] = string == null || string.isEmpty() ? Long.MIN_VALUE : Long.valueOf(string);
        }
    }

    void fillFromParsedListData(List values) {
        this.resize(values.size());
        Iterator iterator = values.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this._data[n2] = (Long)iterator.next();
            ++n2;
        }
    }

    void fillFromColumnData(Object data) {
        this._data = (long[])data;
    }
}

