/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class MojoColumnStr
extends MojoColumn {
    private String[] _data;

    MojoColumnStr(int nrows) {
        this._data = new String[nrows];
    }

    public String debug() {
        return Arrays.toString(this._data);
    }

    public MojoColumn.Type getType() {
        return MojoColumn.Type.Str;
    }

    public Object getData() {
        return this._data;
    }

    public String[] getDataAsStrings() {
        return Arrays.copyOf(this._data, this._data.length);
    }

    public int size() {
        return this._data.length;
    }

    void resize(int n2) {
        if (this._data.length != n2) {
            this._data = new String[n2];
        }
    }

    void fillFromCsvData(String[][] fields, int col) {
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String string = fields[i2][col];
            if (string != null && string.length() > 1) {
                int n2 = string.length() - 1;
                if (string.charAt(0) == '\"' && string.charAt(n2) == '\"') {
                    string = string.substring(1, n2);
                }
            }
            this._data[i2] = string;
        }
    }

    void fillFromParsedListData(List values) {
        this.resize(values.size());
        Iterator iterator = values.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this._data[n2] = (String)iterator.next();
            ++n2;
        }
    }

    void fillFromColumnData(Object data) {
        this._data = (String[])data;
    }
}

