/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.frame;

import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.utils.MojoDateTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class MojoColumnTime64
extends MojoColumn {
    private MojoDateTime[] _data;
    private DateTimeFormatter _format;

    MojoColumnTime64(int nrows) {
        this._data = new MojoDateTime[nrows];
        this._format = ISODateTimeFormat.dateOptionalTimeParser();
    }

    public String debug() {
        return Arrays.toString(this._data);
    }

    public MojoColumn.Type getType() {
        return MojoColumn.Type.Time64;
    }

    public Object getData() {
        return this._data;
    }

    public String[] getDataAsStrings() {
        String[] stringArray = new String[this._data.length];
        for (int i2 = 0; i2 < this._data.length; ++i2) {
            if (this._data[i2] == null) {
                stringArray[i2] = null;
                continue;
            }
            LocalDateTime localDateTime = new LocalDateTime(this._data[i2].getYear(), this._data[i2].getMonth(), this._data[i2].getDay(), this._data[i2].getHour(), this._data[i2].getMinute(), this._data[i2].getSecond());
            stringArray[i2] = this._format.print((ReadablePartial)localDateTime);
        }
        return stringArray;
    }

    public int size() {
        return this._data.length;
    }

    void resize(int n2) {
        if (this._data.length != n2) {
            this._data = new MojoDateTime[n2];
        }
    }

    void fillFromCsvData(String[][] fields, int col) {
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String string = fields[i2][col];
            this._data[i2] = string == null || string.isEmpty() ? null : MojoDateTime.parse((String)string);
        }
    }

    void fillFromParsedListData(List values) {
        this.resize(values.size());
        Iterator iterator = values.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this._data[n2] = (MojoDateTime)iterator.next();
            ++n2;
        }
    }

    void fillFromColumnData(Object data) {
        this._data = (MojoDateTime[])data;
    }
}

