/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.utils.BatchedCsvReader;
import ai.h2o.mojos.runtime.utils.Consts;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;

public class BatchedCsvMojoProcessor {
    static final char ESCAPE_CHAR;
    static final char SEPARATOR;
    private int batchSize = Consts.getSysProp((String)"batch", (int)1000);
    private final MojoPipeline model;

    public BatchedCsvMojoProcessor(MojoPipeline model) {
        this.model = model;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public long processCsv(Reader reader, final BatchHandler batchHandler) throws IOException {
        return this.processCsv(reader, new DualBatchHandler(){

            @Override
            public void handleBatch(int batchNo, MojoFrame iframe, MojoFrame oframe) throws IOException {
                batchHandler.handleBatch(batchNo, oframe);
            }
        });
    }

    public long processCsv(Reader reader, DualBatchHandler batchHandler) throws IOException {
        MojoFrame mojoFrame;
        int n2;
        CSVReader cSVReader = this.openCsvReader(reader);
        int n3 = 0;
        BatchedCsvReader batchedCsvReader = new BatchedCsvReader(this.model, cSVReader, this.batchSize);
        Iterator<MojoFrame> iterator = batchedCsvReader.iterator();
        while (iterator.hasNext() && (n2 = (mojoFrame = iterator.next()).getNrows()) != 0) {
            MojoFrame mojoFrame2 = this.model.transform(mojoFrame);
            batchHandler.handleBatch(n3, mojoFrame, mojoFrame2);
            ++n3;
        }
        return batchedCsvReader.getTotalDataRows();
    }

    protected CSVReader openCsvReader(Reader reader) {
        return BatchedCsvMojoProcessor.readerToCsvReader(reader);
    }

    public static CSVReader readerToCsvReader(Reader reader) {
        BufferedReader bufferedReader = new BufferedReader(reader);
        CSVParserBuilder cSVParserBuilder = new CSVParserBuilder().withEscapeChar(ESCAPE_CHAR).withSeparator(SEPARATOR).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS);
        CSVReaderBuilder cSVReaderBuilder = new CSVReaderBuilder((Reader)bufferedReader).withCSVParser((ICSVParser)cSVParserBuilder.build());
        cSVReaderBuilder.withKeepCarriageReturn(Consts.getSysProp((String)"parser.csv.keepCarriageReturn", (boolean)true));
        return cSVReaderBuilder.build();
    }

    static String stripCrFromEol(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        int n2 = value.length();
        while (value.charAt(--n2) == '\r') {
        }
        return value.substring(0, n2 + 1);
    }

    static {
        String string;
        switch (string = Consts.getSysProp((String)"separator", (String)",")) {
            case "TAB": {
                SEPARATOR = (char)9;
                break;
            }
            default: {
                if (string.length() != 1) {
                    throw new IllegalStateException("Separator value is '%s', but it must be 'TAB' or exactly one character");
                }
                SEPARATOR = string.charAt(0);
            }
        }
        String string2 = Consts.getSysProp((String)"escapeChar", (String)"");
        if (string2.length() == 0) {
            ESCAPE_CHAR = '\u0000';
            return;
        }
        if (string2.length() == 1) {
            ESCAPE_CHAR = string2.charAt(0);
            return;
        }
        throw new IllegalStateException("Escape char value is '%s', but it must be either empty string or exactly one character");
    }

    public static interface DualBatchHandler {
        public void handleBatch(int var1, MojoFrame var2, MojoFrame var3) throws IOException;
    }

    public static interface BatchHandler {
        public void handleBatch(int var1, MojoFrame var2) throws IOException;
    }
}

