/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoRowBuilder;
import ai.h2o.mojos.runtime.utils.BatchedCsvMojoProcessor;
import ai.h2o.mojos.runtime.utils.Consts;
import com.opencsv.CSVReader;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.NoSuchElementException;

public class BatchedCsvReader
implements Iterable<MojoFrame>,
Iterator<MojoFrame> {
    private static final boolean STRIP_CR_FROM_LAST_COLUMN = Consts.getSysProp((String)"parser.csv.stripCrFromLastColumn", (boolean)true);
    private final Iterator<String[]> csvReaderIter;
    private final int batchSize;
    private final MojoPipeline model;
    private final int[] csvColPointers;
    private final int labelCount;
    private long totalDataRows = 0L;
    private boolean hasNext = true;

    public BatchedCsvReader(MojoPipeline model, CSVReader csvReader, int batchSize) {
        Object object;
        int n2;
        this.csvReaderIter = csvReader.iterator();
        this.batchSize = batchSize;
        this.model = model;
        String[] stringArray = this.csvReaderIter.next();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            object = stringArray2[n2];
            linkedHashMap.put(((String)object).trim(), linkedHashMap.size());
        }
        stringArray2 = model.getInputMeta().getColumnNames();
        n3 = stringArray2.length;
        this.csvColPointers = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object = (Integer)linkedHashMap.get(stringArray2[n2]);
            if (object == null) {
                throw new IllegalArgumentException(String.format("Model requires column named '%s' but it is not present in input data", stringArray2[n2]));
            }
            this.csvColPointers[n2] = (Integer)object;
        }
        this.labelCount = stringArray.length;
    }

    public long getTotalDataRows() {
        return this.totalDataRows;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public MojoFrame next() {
        if (!this.hasNext) {
            throw new NoSuchElementException(String.format("No more data after reading %d rows", this.totalDataRows));
        }
        MojoFrameBuilder mojoFrameBuilder = this.model.getInputFrameBuilder();
        int n2 = this.csvColPointers.length;
        int n3 = 0;
        MojoRowBuilder mojoRowBuilder = mojoFrameBuilder.getMojoRowBuilder();
        while (this.csvReaderIter.hasNext()) {
            String[] stringArray = this.csvReaderIter.next();
            if (stringArray.length != this.labelCount) {
                throw new IllegalArgumentException(String.format("Invalid CSV data: row #%d (in current batch) has %d columns but header defines %d columns", this.totalDataRows, stringArray.length, this.labelCount));
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n4 = this.csvColPointers[i2];
                String string = STRIP_CR_FROM_LAST_COLUMN && n4 == n2 - 1 ? BatchedCsvMojoProcessor.stripCrFromEol(stringArray[n4]) : stringArray[n4];
                mojoRowBuilder.setValue(i2, string);
            }
            mojoRowBuilder = mojoFrameBuilder.addRow(mojoRowBuilder);
            if (++n3 > this.batchSize) break;
            ++this.totalDataRows;
        }
        this.hasNext = this.csvReaderIter.hasNext();
        return mojoFrameBuilder.toMojoFrame();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public Iterator<MojoFrame> iterator() {
        return this;
    }
}

