/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.api.BasePipelineListener;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginalMatrix {
    private static final Logger log = LoggerFactory.getLogger(OriginalMatrix.class);
    private final Map<String, Row> rows = new LinkedHashMap<String, Row>();

    public void add(String transName, String origName, double coef) {
        Row row = this.rows.get(transName);
        if (row == null) {
            row = new Row();
            this.rows.put(transName, row);
        }
        row.addValue(origName, coef);
    }

    public void apply(MojoFrame globalFrame, BasePipelineListener listener) {
        int n2 = globalFrame.getNrows();
        MojoFrameMeta mojoFrameMeta = globalFrame.getMeta();
        log.trace("Applying OriginalMatrix");
        for (Map.Entry<String, Row> entry : this.rows.entrySet()) {
            Row row = entry.getValue();
            String string = entry.getKey();
            Integer n3 = globalFrame.getMeta().indexOf(string);
            if (n3 == null) {
                log.warn("Transformed column not found: '{}'; we assume ZERO output and ignore mappings: {}", (Object)string, (Object)row);
                continue;
            }
            double[] dArray = (double[])globalFrame.getColumnData(n3.intValue());
            for (Map.Entry entry2 : row.byOrigName.entrySet()) {
                String string2 = (String)entry2.getKey();
                int n4 = mojoFrameMeta.getColumnIndex(string2);
                double[] dArray2 = (double[])globalFrame.getColumnData(n4);
                double d2 = (Double)entry2.getValue();
                int n5 = 0;
                while (n5 < n2) {
                    double d3 = dArray[n5];
                    int n6 = n5++;
                    dArray2[n6] = dArray2[n6] + d3 * d2;
                }
                listener.onTransformStep(String.format("adding %f x %s", d2, string), n4);
            }
        }
    }

    public Map<String, Double> getRow(String transName) {
        Row row = this.rows.get(transName);
        if (row == null) {
            return Collections.emptyMap();
        }
        return row.byOrigName;
    }

    public static class Row {
        private final Map<String, Double> byOrigName = new LinkedHashMap<String, Double>();

        public void addValue(String origName, double coef) {
            this.byOrigName.put(origName, coef);
        }

        public double get(String origName) {
            return this.byOrigName.get(origName);
        }

        public String toString() {
            return this.byOrigName.toString();
        }
    }
}

