/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.transforms;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.AbstractMojoTransformBuilderFactory;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.a.a;
import java.util.Map;

public class MojoTransformStringConcat
extends MojoTransform {
    private final String nullRepresentation;

    public MojoTransformStringConcat(MojoFrameMeta meta, int[] iindices, int[] oindices, String nullRepre) {
        super(meta, iindices, oindices);
        this.nullRepresentation = nullRepre;
        assert (oindices.length == 1) : "must have only one output column";
        MojoColumn.Type type = meta.getColumnType(iindices[0]);
        MojoColumn.Type type2 = meta.getColumnType(oindices[0]);
        a.a(type, 256, "Input column must be of String type");
        a.a(type2, 256, "Output column must be of String type");
    }

    public void transform(MojoFrame frame) {
        for (int i2 = 0; i2 < frame.getNrows(); ++i2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i3 = 0; i3 < this.iindices.length; ++i3) {
                String string = ((String[])frame.getColumnData(this.iindices[i3]))[i2];
                stringBuilder.append(string != null ? string : this.nullRepresentation);
                if (i3 < this.iindices.length - 1) {
                    stringBuilder.append(":");
                }
                String[] stringArray = (String[])frame.getColumnData(this.oindices[0]);
                String[] stringArray2 = stringArray;
                stringArray[i2] = stringBuilder.toString();
            }
        }
    }

    public static class Factory
    extends AbstractMojoTransformBuilderFactory {
        public static String DEFAULT_NULL_REPRE = "nan";

        @Override
        protected Class<?> getTransformerClass() {
            return MojoTransformStringConcat.class;
        }

        public MojoTransform createBuilder(MojoFrameMeta meta, int[] iindices, int[] oindices, Map<String, Object> params, ReaderBackend backend) {
            String string = params.containsKey("nullRepresentation") ? (String)params.get("nullRepresentation") : DEFAULT_NULL_REPRE;
            return new MojoTransformStringConcat(meta, iindices, oindices, string);
        }
    }
}

