/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeFieldType;
import org.joda.time.format.DateTimeParserBucket;

class Year4DigitISOParse
extends SubParser {
    Year4DigitISOParse() {
    }

    public int estimateParsedLength() {
        return 4;
    }

    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 4) {
            return ~position;
        }
        char[] cArray = new char[4];
        int n2 = position;
        text.getChars(n2, n2 + 4, cArray, 0);
        if (cArray[0] < '0' || cArray[0] > '9') {
            return ~position;
        }
        if (cArray[1] < '0' || cArray[1] > '9') {
            return ~(position + 1);
        }
        if (cArray[2] < '0' || cArray[2] > '9') {
            return ~(position + 2);
        }
        if (cArray[3] < '0' || cArray[3] > '9') {
            return ~(position + 3);
        }
        int n3 = (cArray[0] - 48) * 1000 + (cArray[1] - 48) * 100 + (cArray[2] - 48) * 10 + cArray[3] - 48;
        int n4 = position + 4;
        if (this.child != null) {
            n4 = this.child.parseInto(bucket, text, n4);
        } else if (this.ignoreSuffix) {
            n4 = text.length();
        }
        if (n4 >= 0) {
            bucket.saveField(DateTimeFieldType.weekyear(), n3);
        }
        return n4;
    }
}

