/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.GeneratedMessageLite;
import ai.h2o.com.google.protobuf.MessageLite;
import ai.h2o.com.google.protobuf.TextFormatEscaper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class MessageLiteToString {
    private static final String LIST_SUFFIX = "List";
    private static final String BUILDER_LIST_SUFFIX = "OrBuilderList";
    private static final String MAP_SUFFIX = "Map";
    private static final String BYTES_SUFFIX = "Bytes";
    private static final char[] INDENT_BUFFER = new char[80];

    private MessageLiteToString() {
    }

    static String toString(MessageLite messageLite, String commentString) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# ").append(commentString);
        MessageLiteToString.reflectivePrintWithIndent(messageLite, stringBuilder, 0);
        return stringBuilder.toString();
    }

    private static void reflectivePrintWithIndent(MessageLite messageLite, StringBuilder buffer, int indent) {
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        TreeMap<String, Method> treeMap = new TreeMap<String, Method>();
        for (Method method : messageLite.getClass().getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers()) || method.getName().length() < 3) continue;
            if (method.getName().startsWith("set")) {
                hashSet.add(method.getName());
                continue;
            }
            if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            if (method.getName().startsWith("has")) {
                hashMap.put(method.getName(), method);
                continue;
            }
            if (!method.getName().startsWith("get")) continue;
            treeMap.put(method.getName(), method);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            boolean bl;
            Method method;
            String string = ((String)entry.getKey()).substring(3);
            if (string.endsWith(LIST_SUFFIX) && !string.endsWith(BUILDER_LIST_SUFFIX) && !string.equals(LIST_SUFFIX) && (method = (Method)entry.getValue()) != null && method.getReturnType().equals(List.class)) {
                MessageLiteToString.printField(buffer, indent, string.substring(0, string.length() - 4), GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]));
                continue;
            }
            if (string.endsWith(MAP_SUFFIX) && !string.equals(MAP_SUFFIX) && (method = (Method)entry.getValue()) != null && method.getReturnType().equals(Map.class) && !method.isAnnotationPresent(Deprecated.class) && Modifier.isPublic(method.getModifiers())) {
                MessageLiteToString.printField(buffer, indent, string.substring(0, string.length() - 3), GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]));
                continue;
            }
            if (!hashSet.contains("set" + string) || string.endsWith(BYTES_SUFFIX) && treeMap.containsKey("get" + string.substring(0, string.length() - 5))) continue;
            method = (Method)entry.getValue();
            Method method2 = (Method)hashMap.get("has" + string);
            if (method == null) continue;
            Object object = GeneratedMessageLite.invokeOrDie(method, messageLite, new Object[0]);
            boolean bl2 = method2 == null ? !MessageLiteToString.isDefaultValue(object) : (bl = ((Boolean)GeneratedMessageLite.invokeOrDie(method2, messageLite, new Object[0])).booleanValue());
            if (!bl2) continue;
            MessageLiteToString.printField(buffer, indent, string, object);
        }
        if (messageLite instanceof GeneratedMessageLite.ExtendableMessage) {
            Iterator<Map.Entry<GeneratedMessageLite.ExtensionDescriptor, Object>> iterator = ((GeneratedMessageLite.ExtendableMessage)messageLite).extensions.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                MessageLiteToString.printField(buffer, indent, "[" + ((GeneratedMessageLite.ExtensionDescriptor)entry.getKey()).getNumber() + "]", entry.getValue());
            }
        }
        if (((GeneratedMessageLite)messageLite).unknownFields != null) {
            ((GeneratedMessageLite)messageLite).unknownFields.printWithIndent(buffer, indent);
        }
    }

    private static boolean isDefaultValue(Object o2) {
        if (o2 instanceof Boolean) {
            return (Boolean)o2 == false;
        }
        if (o2 instanceof Integer) {
            return (Integer)o2 == 0;
        }
        if (o2 instanceof Float) {
            return Float.floatToRawIntBits(((Float)o2).floatValue()) == 0;
        }
        if (o2 instanceof Double) {
            return Double.doubleToRawLongBits((Double)o2) == 0L;
        }
        if (o2 instanceof String) {
            return o2.equals("");
        }
        if (o2 instanceof ByteString) {
            return o2.equals(ByteString.EMPTY);
        }
        if (o2 instanceof MessageLite) {
            Object object = o2;
            return object == ((MessageLite)object).getDefaultInstanceForType();
        }
        if (o2 instanceof Enum) {
            return ((Enum)o2).ordinal() == 0;
        }
        return false;
    }

    static void printField(StringBuilder buffer, int indent, String name, Object object) {
        if (object instanceof List) {
            List list = (List)object;
            for (Object e2 : list) {
                MessageLiteToString.printField(buffer, indent, name, e2);
            }
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                MessageLiteToString.printField(buffer, indent, name, entry);
            }
            return;
        }
        buffer.append('\n');
        MessageLiteToString.indent(indent, buffer);
        buffer.append(MessageLiteToString.pascalCaseToSnakeCase(name));
        if (object instanceof String) {
            buffer.append(": \"").append(TextFormatEscaper.escapeText((String)object)).append('\"');
            return;
        }
        if (object instanceof ByteString) {
            buffer.append(": \"").append(TextFormatEscaper.escapeBytes((ByteString)object)).append('\"');
            return;
        }
        if (object instanceof GeneratedMessageLite) {
            buffer.append(" {");
            MessageLiteToString.reflectivePrintWithIndent((GeneratedMessageLite)object, buffer, indent + 2);
            buffer.append("\n");
            MessageLiteToString.indent(indent, buffer);
            buffer.append("}");
            return;
        }
        if (object instanceof Map.Entry) {
            buffer.append(" {");
            Map.Entry entry = (Map.Entry)object;
            MessageLiteToString.printField(buffer, indent + 2, "key", entry.getKey());
            MessageLiteToString.printField(buffer, indent + 2, "value", entry.getValue());
            buffer.append("\n");
            MessageLiteToString.indent(indent, buffer);
            buffer.append("}");
            return;
        }
        buffer.append(": ").append(object);
    }

    private static void indent(int indent, StringBuilder buffer) {
        while (indent > 0) {
            int n2 = indent;
            if (n2 > INDENT_BUFFER.length) {
                n2 = INDENT_BUFFER.length;
            }
            buffer.append(INDENT_BUFFER, 0, n2);
            indent -= n2;
        }
    }

    private static String pascalCaseToSnakeCase(String pascalCase) {
        if (pascalCase.isEmpty()) {
            return pascalCase;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Character.toLowerCase(pascalCase.charAt(0)));
        for (int i2 = 1; i2 < pascalCase.length(); ++i2) {
            char c2 = pascalCase.charAt(i2);
            if (Character.isUpperCase(c2)) {
                stringBuilder.append("_");
            }
            stringBuilder.append(Character.toLowerCase(c2));
        }
        return stringBuilder.toString();
    }

    static {
        Arrays.fill(INDENT_BUFFER, ' ');
    }
}

