/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.ColumnOptimizer;
import ai.h2o.mojos.runtime.ExposedColumnNames;
import ai.h2o.mojos.runtime.MojoPipeline;
import ai.h2o.mojos.runtime.PipelineWiring;
import ai.h2o.mojos.runtime.ShapBlender;
import ai.h2o.mojos.runtime.api.BasePipelineListener;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.api.PipelineConfig;
import ai.h2o.mojos.runtime.frame.MojoColumn;
import ai.h2o.mojos.runtime.frame.MojoColumnFactoryImpl;
import ai.h2o.mojos.runtime.frame.MojoFrame;
import ai.h2o.mojos.runtime.frame.MojoFrameBuilder;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.frame.StringConverter;
import ai.h2o.mojos.runtime.frame.StringToDateConverter;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.transforms.MojoTransformExecPipeBuilder;
import ai.h2o.mojos.runtime.transforms.a;
import ai.h2o.mojos.runtime.utils.ArrayReaderUtils;
import ai.h2o.mojos.runtime.utils.DateParser;
import ai.h2o.mojos.runtime.utils.MojoDateTimeParserFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoPipelineProtoImpl
extends MojoPipeline {
    private static final Logger log = LoggerFactory.getLogger(MojoPipelineProtoImpl.class);
    private final PipelineConfig config;
    private final List<MojoColumnMeta> globalColumns;
    private final MojoTransformExecPipeBuilder root;
    private BasePipelineListener listener;
    private final Map<String, StringConverter> dateTimeConverters = new HashMap<String, StringConverter>(0);
    private boolean shapEnabled;
    private AllocatedBuffers allocatedBuffers;
    private boolean shapOriginal;

    public MojoPipelineProtoImpl(List<MojoColumnMeta> globalColumns, MojoTransformExecPipeBuilder root, PipelineConfig config) {
        super(root.pipelineMeta.uuid, root.pipelineMeta.creationTime, root.pipelineMeta.license);
        this.root = root;
        this.globalColumns = globalColumns;
        this.config = config;
        this.shapEnabled = config.isShapEnabled();
        this.shapOriginal = config.isShapOriginal();
        this.listener = config.getListener();
        if (root.pipelineMeta.datetimeStringFormats != null) {
            for (Map.Entry<String, String> entry : root.pipelineMeta.datetimeStringFormats.entrySet()) {
                DateParser dateParser = new DateParser(MojoDateTimeParserFactory.forPattern(entry.getValue(), false));
                this.dateTimeConverters.put(entry.getKey(), new StringToDateConverter(dateParser));
            }
        }
    }

    public MojoFrameBuilder getOutputFrameBuilder(MojoFrameBuilder inputFrameBuilder) {
        MojoFrameMeta mojoFrameMeta = this.getMeta(MojoColumn.Kind.Output);
        return MojoFrameBuilder.withSharedColumns((MojoFrameMeta)mojoFrameMeta, (MojoFrameBuilder)inputFrameBuilder);
    }

    protected MojoFrameBuilder getFrameBuilder(MojoColumn.Kind kind) {
        return new MojoFrameBuilder(this.getMeta(kind), Arrays.asList(this.root.pipelineMeta.missingValues), this.dateTimeConverters);
    }

    protected MojoFrameMeta getMeta(MojoColumn.Kind kind) {
        switch (kind) {
            case Feature: {
                return this.buffers().inputFrameMeta;
            }
            case Output: {
                return this.buffers().outputFrameMeta;
            }
        }
        throw new UnsupportedOperationException("Cannot generate meta for interim frame");
    }

    MojoFrame constructGlobalFrame(MojoFrame inputFrame, MojoFrame outputFrame, int[] slotIndices, int slotCount) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MojoFrameMeta mojoFrameMeta = inputFrame.getMeta();
        MojoFrameMeta mojoFrameMeta2 = outputFrame.getMeta();
        ArrayList<MojoColumnMeta> arrayList2 = new ArrayList<MojoColumnMeta>(this.globalColumns);
        int n2 = inputFrame.getNrows();
        MojoColumnFactoryImpl mojoColumnFactoryImpl = new MojoColumnFactoryImpl();
        MojoColumn[] mojoColumnArray = new MojoColumn[slotCount];
        int n3 = mojoFrameMeta.size() + mojoFrameMeta2.size();
        log.trace("inputs: {} outputs: {} columns: {}", new Object[]{mojoFrameMeta.size(), mojoFrameMeta2.size(), arrayList2.size()});
        int n4 = -1;
        for (MojoColumnMeta mojoColumnMeta : arrayList2) {
            MojoColumn mojoColumn;
            int n5;
            Object object;
            ++n4;
            Integer n6 = mojoFrameMeta.indexOf(mojoColumnMeta);
            if (n6 != null) {
                object = inputFrame.getColumn(n6.intValue());
                int n7 = slotIndices[n4];
                if (mojoColumnArray[n7] != null) {
                    throw new RuntimeException(String.format("Input column #%d (%s) already allocated in slot #%d", n6, mojoColumnMeta.getColumnName(), n7));
                }
                log.trace("column[{}] : in buffer[{},{}]  {} = {}", new Object[]{n4, n7, mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName(), object});
                mojoColumnArray[n7] = object;
                arrayList.add(object);
                continue;
            }
            object = mojoFrameMeta2.indexOf(mojoColumnMeta);
            if (object != null) {
                MojoColumn mojoColumn2 = outputFrame.getColumn(((Integer)object).intValue());
                n5 = slotIndices[n4];
                if (n5 >= 0) {
                    if (mojoColumnArray[n5] != null) {
                        throw new RuntimeException(String.format("Output column #%d (%s) already allocated in slot #%d", object, mojoColumnMeta.getColumnName(), n5));
                    }
                    mojoColumnArray[n5] = mojoColumn2;
                }
                log.trace("column[{}] : out buffer[{},{}]  {} = {}", new Object[]{n4, n5, mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName(), mojoColumn2});
                arrayList.add(mojoColumn2);
                continue;
            }
            if (n4 < slotIndices.length) {
                n5 = slotIndices[n4];
                if (n5 < 0) {
                    mojoColumn = null;
                    log.trace("column[{}] : ignored ", (Object)n4);
                } else if (mojoColumnArray[n5] != null) {
                    mojoColumn = mojoColumnArray[n5];
                    log.trace("column[{}] : reused buffer[{},{}] {} = {}", new Object[]{n4, n5, mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName(), mojoColumn});
                } else {
                    mojoColumn = mojoColumnFactoryImpl.create(mojoColumnMeta.getColumnType(), n2);
                    log.trace("column[{}] : new buffer[{},{}] {} = {}", new Object[]{n4, n5, mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName(), mojoColumn});
                    mojoColumnArray[n5] = mojoColumn;
                    ++n3;
                }
            } else {
                mojoColumn = mojoColumnFactoryImpl.create(mojoColumnMeta.getColumnType(), n2);
                log.trace("column[{}] : shap {}", (Object)n4, (Object)mojoColumn);
                ++n3;
            }
            arrayList.add(mojoColumn);
        }
        log.debug("Allocated {} buffers for {} columns", (Object)n3, (Object)arrayList.size());
        return MojoFrameBuilder.fromColumns((MojoFrameMeta)this.buffers().globalMeta, (MojoColumn[])arrayList.toArray(new MojoColumn[0]));
    }

    public MojoFrame transform(MojoFrame inputFrame, MojoFrame outputFrame) {
        assert (outputFrame.getNcols() > 0);
        AllocatedBuffers allocatedBuffers = this.buffers();
        MojoFrame mojoFrame = this.constructGlobalFrame(inputFrame, outputFrame, allocatedBuffers.slots, allocatedBuffers.slotCount);
        this.listener.onBatchStart(mojoFrame, this.root.iindices);
        for (MojoTransform mojoTransform : allocatedBuffers.wiring.transformsFlattened) {
            this.listener.onTransformHead(mojoTransform);
            mojoTransform.transform(mojoFrame);
            this.listener.onTransformResult(mojoTransform);
        }
        if (this.shapEnabled) {
            for (MojoTransform mojoTransform : allocatedBuffers.wiring.shapTransforms) {
                allocatedBuffers.shapBlender.computeShap(mojoFrame, mojoTransform);
            }
        }
        this.listener.onBatchEnd();
        return outputFrame;
    }

    @Deprecated
    public void setShapPredictContrib(boolean enable) {
        if (enable == this.shapEnabled) {
            return;
        }
        if (this.allocatedBuffers != null) {
            throw new IllegalStateException("Cannot change SHAP flag after internal buffers have been allocated");
        }
        this.shapEnabled = enable;
    }

    @Deprecated
    public void setShapPredictContribOriginal(boolean enable) {
        this.setShapPredictContrib(true);
        if (enable == this.shapOriginal) {
            return;
        }
        this.shapOriginal = true;
    }

    @Deprecated
    public void setListener(BasePipelineListener listener) {
        this.listener = listener;
    }

    public void printPipelineInfo(PrintStream out) {
        out.println("UUID: " + this.root.pipelineMeta.uuid);
        out.println("Created: " + this.root.pipelineMeta.creationTime);
        out.println("Problem info: " + this.root.pipelineMeta.problemInfo);
        out.println("Class labels: " + this.root.pipelineMeta.outputClassLabels);
        out.println("Inputs:");
        for (MojoColumnMeta mojoColumnMeta : this.getInputMeta().getColumns()) {
            out.printf("* %s %s\n", mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName());
        }
        out.println("Outputs:");
        for (MojoColumnMeta mojoColumnMeta : this.getOutputMeta().getColumns()) {
            out.printf("* %s %s\n", mojoColumnMeta.getColumnType(), mojoColumnMeta.getColumnName());
        }
    }

    private synchronized AllocatedBuffers buffers() {
        if (this.allocatedBuffers == null) {
            log.trace("Allocating buffers");
            this.allocatedBuffers = new AllocatedBuffers();
        }
        return this.allocatedBuffers;
    }

    private class AllocatedBuffers {
        final MojoFrameMeta globalMeta;
        final PipelineWiring wiring;
        final MojoFrameMeta inputFrameMeta;
        final MojoFrameMeta outputFrameMeta;
        final ShapBlender shapBlender;
        final int[] slots;
        final int slotCount;

        public AllocatedBuffers() {
            Object object;
            Object object2;
            Object object3;
            int[] nArray;
            this.wiring = new PipelineWiring(MojoPipelineProtoImpl.this.globalColumns, MojoPipelineProtoImpl.this.root);
            this.wiring.reportPrematureTraversals();
            if (!MojoPipelineProtoImpl.this.shapEnabled) {
                nArray = ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.oindices;
                this.shapBlender = null;
            } else {
                if (this.wiring.isTreeMetalearner()) {
                    throw new UnsupportedOperationException("Computing SHAP contributions is not supported for pipelines with tree metalearner");
                }
                this.shapBlender = new ShapBlender(MojoPipelineProtoImpl.this.globalColumns, MojoPipelineProtoImpl.this.root, MojoPipelineProtoImpl.this.shapOriginal);
                object3 = this.shapBlender.prepareShapColumns(this.wiring);
                nArray = ArrayReaderUtils.fromIntegerListToArray(object3);
            }
            if (nArray.length == 0) {
                throw new IllegalStateException("No columns in output frame");
            }
            object3 = ExposedColumnNames.extend(MojoPipelineProtoImpl.this.globalColumns, MojoPipelineProtoImpl.this.config.getExposedColumnNames(), ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.iindices, nArray);
            this.globalMeta = new MojoFrameMeta(MojoPipelineProtoImpl.this.globalColumns);
            ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.pipelineMeta.consistencyChecks(this.globalMeta);
            this.inputFrameMeta = this.globalMeta.subFrame(((ExposedColumnNames)object3).extendedInputs);
            this.outputFrameMeta = this.globalMeta.subFrame(((ExposedColumnNames)object3).extendedOutputs);
            for (MojoTransform stringArray : this.wiring.transformsFlattened) {
                if (!(stringArray instanceof a)) continue;
                log.trace("Steps are traceable in {}", (Object)stringArray);
                a a2 = (a)stringArray;
                object2 = a2;
                a2.a(MojoPipelineProtoImpl.this.listener);
            }
            if (MojoPipelineProtoImpl.this.shapEnabled) {
                object = ColumnOptimizer.dummy(MojoPipelineProtoImpl.this.globalColumns);
                log.debug("Column optimizer ignored for SHAP");
            } else {
                String[] stringArray = MojoPipelineProtoImpl.this.config.getExposedColumnNames();
                object2 = this.globalMeta.namesToIndices(stringArray);
                object = ColumnOptimizer.optimize(this.wiring.transformsFlattened, ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.iindices, ((MojoPipelineProtoImpl)MojoPipelineProtoImpl.this).root.oindices, object2, MojoPipelineProtoImpl.this.globalColumns);
                log.debug("Column optimizer needs {} slots for {} columns: {}", new Object[]{((ColumnOptimizer)object).getSlotCount(), MojoPipelineProtoImpl.this.globalColumns.size(), ((ColumnOptimizer)object).getSlots()});
            }
            this.slots = ((ColumnOptimizer)object).getSlots();
            this.slotCount = ((ColumnOptimizer)object).getSlotCount();
        }
    }
}

