/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime;

import ai.h2o.mojos.runtime.PipelineWiring;
import ai.h2o.mojos.runtime.api.MojoColumnMeta;
import ai.h2o.mojos.runtime.frame.MojoFrameMeta;
import ai.h2o.mojos.runtime.transforms.I;
import ai.h2o.mojos.runtime.transforms.MojoTransform;
import ai.h2o.mojos.runtime.utils.ArrayReaderUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TargetOutputLookup {
    private static final Logger log = LoggerFactory.getLogger(TargetOutputLookup.class);
    private final Map<Integer, List<Integer>> targetOutputs = new LinkedHashMap<Integer, List<Integer>>();
    private final PipelineWiring wiring;

    public TargetOutputLookup(int[] oindices, PipelineWiring wiring) {
        this.wiring = wiring;
        for (int i2 = 0; i2 < oindices.length; ++i2) {
            int n2 = oindices[i2];
            this.assignTargetOutput(i2, n2);
        }
    }

    private void assignTargetOutput(int targetOutput, int index) {
        MojoTransform mojoTransform;
        List list = this.targetOutputs.computeIfAbsent(index, k2 -> new ArrayList());
        if (!list.contains(targetOutput)) {
            list.add(targetOutput);
        }
        if ((mojoTransform = this.wiring.getProducer(index)) == null) {
            return;
        }
        if (mojoTransform instanceof I) {
            this.assignTargetOutput(targetOutput, mojoTransform.iindices[targetOutput]);
            return;
        }
        int[] nArray = mojoTransform.iindices;
        int n2 = mojoTransform.iindices.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            this.assignTargetOutput(targetOutput, n3);
        }
    }

    public int lookup(int index) {
        List<Integer> list = this.targetOutputs.get(index);
        List<MojoColumnMeta> list2 = this.wiring.getColumns();
        if (list == null || list.isEmpty()) {
            throw new IllegalStateException(String.format("No target output exists for index %d (column '%s')", index, list2.get(index).getColumnName()));
        }
        if (list.size() > 1) {
            log.debug("Multiple target outputs: {}", (Object)MojoFrameMeta.debugIndicesToNames(list2, (int[])ArrayReaderUtils.fromIntegerListToArray(list)));
            throw new IllegalStateException(String.format("%d target outputs exist for index %d (column '%s'): %s", list.size(), index, list2.get(index).getColumnName(), list));
        }
        return list.get(0);
    }
}

