/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.DatatableLikeCSVParser;
import com.opencsv.ICSVParser;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import java.util.Locale;
import org.apache.commons.lang3.ObjectUtils;

public class DatatableLikeCSVParserBuilder {
    private char separator = (char)44;
    private char quoteChar = (char)34;
    private char escapeChar = (char)92;
    private boolean strictQuotes = false;
    private boolean ignoreLeadingWhiteSpace = true;
    private boolean ignoreQuotations = false;
    private CSVReaderNullFieldIndicator nullFieldIndicator = CSVReaderNullFieldIndicator.NEITHER;
    private Locale errorLocale = Locale.getDefault();
    private boolean ignoreUnquotedFieldSurroundingSpaces;

    public DatatableLikeCSVParserBuilder withSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    public DatatableLikeCSVParserBuilder withQuoteChar(char quoteChar) {
        this.quoteChar = quoteChar;
        return this;
    }

    public DatatableLikeCSVParserBuilder withEscapeChar(char escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    public DatatableLikeCSVParserBuilder withStrictQuotes(boolean strictQuotes) {
        this.strictQuotes = strictQuotes;
        return this;
    }

    public DatatableLikeCSVParserBuilder withIgnoreLeadingWhiteSpace(boolean ignoreLeadingWhiteSpace) {
        this.ignoreLeadingWhiteSpace = ignoreLeadingWhiteSpace;
        return this;
    }

    public DatatableLikeCSVParserBuilder withIgnoreQuotations(boolean ignoreQuotations) {
        this.ignoreQuotations = ignoreQuotations;
        return this;
    }

    public DatatableLikeCSVParserBuilder withFieldAsNull(CSVReaderNullFieldIndicator fieldIndicator) {
        this.nullFieldIndicator = fieldIndicator;
        return this;
    }

    public DatatableLikeCSVParserBuilder withErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
        return this;
    }

    public DatatableLikeCSVParserBuilder withIgnoreUnquotedFieldSurroundingSpaces(boolean trim) {
        this.ignoreUnquotedFieldSurroundingSpaces = trim;
        return this;
    }

    public ICSVParser build() {
        DatatableLikeCSVParser datatableLikeCSVParser = new DatatableLikeCSVParser(this.separator, this.quoteChar, this.escapeChar, this.strictQuotes, this.ignoreLeadingWhiteSpace, this.ignoreQuotations, this.nullFieldIndicator, this.errorLocale, this.ignoreUnquotedFieldSurroundingSpaces);
        return datatableLikeCSVParser;
    }
}

