/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.utils;

import ai.h2o.mojos.runtime.utils.SubParser;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeParserBucket;

class Zone3LetterParse
extends SubParser {
    private static final int TO_LOWER = 32;

    Zone3LetterParse() {
    }

    public int estimateParsedLength() {
        return 3;
    }

    public int parseInto(DateTimeParserBucket bucket, String text, int position) {
        if (position < 0) {
            throw new IllegalArgumentException("position cannot be negative");
        }
        if (position > text.length() - 3) {
            return ~position;
        }
        char[] cArray = new char[3];
        int n2 = position;
        text.getChars(n2, n2 + 3, cArray, 0);
        if (cArray[0] < 'a' || cArray[0] > 'z') {
            if (cArray[0] < 'A' || cArray[0] > 'Z') {
                return ~position;
            }
            cArray[0] = (char)(cArray[0] + 32);
        }
        if (cArray[1] < 'a' || cArray[1] > 'z') {
            if (cArray[1] < 'A' || cArray[1] > 'Z') {
                return ~(position + 1);
            }
            cArray[1] = (char)(cArray[1] + 32);
        }
        if (cArray[2] < 'a' || cArray[2] > 'z') {
            if (cArray[2] < 'A' || cArray[2] > 'Z') {
                return ~(position + 2);
            }
            cArray[2] = (char)(cArray[2] + 32);
        }
        switch (cArray[0]) {
            case 'u': {
                if (cArray[1] != 't') {
                    return ~(position + 1);
                }
                if (cArray[2] == 'c') break;
                return ~(position + 2);
            }
            case 'g': {
                if (cArray[1] != 'm') {
                    return ~(position + 1);
                }
                if (cArray[2] == 't') break;
                return ~(position + 2);
            }
            default: {
                return ~position;
            }
        }
        int n3 = position + 3;
        if (this.child != null) {
            n3 = this.child.parseInto(bucket, text, n3);
        } else if (this.ignoreSuffix) {
            n3 = text.length();
        }
        if (n3 >= 0) {
            bucket.setZone(DateTimeZone.forOffsetHours((int)0));
        }
        return n3;
    }
}

