/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.ClassPoolTail;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.Translator;
import ai.h2o.javassist.bytecode.ClassFile;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class Loader
extends ClassLoader {
    private HashMap<String, ClassLoader> notDefinedHere;
    private Vector<String> notDefinedPackages;
    private ClassPool source;
    private Translator translator;
    private ProtectionDomain domain;
    public boolean doDelegation = true;

    public Loader() {
        this((ClassPool)null);
    }

    public Loader(ClassPool cp) {
        this.init(cp);
    }

    public Loader(ClassLoader parent, ClassPool cp) {
        super(parent);
        this.init(cp);
    }

    private void init(ClassPool cp) {
        this.notDefinedHere = new HashMap();
        this.notDefinedPackages = new Vector();
        this.source = cp;
        this.translator = null;
        this.domain = null;
        this.delegateLoadingOf("ai.h2o.javassist.Loader");
    }

    public void delegateLoadingOf(String classname) {
        if (classname.endsWith(".")) {
            this.notDefinedPackages.addElement(classname);
            return;
        }
        this.notDefinedHere.put(classname, this);
    }

    public void setDomain(ProtectionDomain d2) {
        this.domain = d2;
    }

    public void setClassPool(ClassPool cp) {
        this.source = cp;
    }

    public void addTranslator(ClassPool cp, Translator t2) throws NotFoundException, CannotCompileException {
        this.source = cp;
        this.translator = t2;
        t2.start(cp);
    }

    public static void main(String[] args) throws Throwable {
        Loader loader = new Loader();
        loader.run(args);
    }

    public void run(String[] args) throws Throwable {
        if (args.length > 0) {
            this.run(args[0], Arrays.copyOfRange(args, 1, args.length));
        }
    }

    public void run(String classname, String[] args) throws Throwable {
        Class<?> clazz = this.loadClass(classname);
        try {
            clazz.getDeclaredMethod("main", String[].class).invoke(null, new Object[]{args});
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw invocationTargetException.getTargetException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassFormatError, ClassNotFoundException {
        String string = name = name.intern();
        synchronized (name) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                clazz = this.loadClassByDelegation(name);
            }
            if (clazz == null) {
                clazz = this.findClass(name);
            }
            if (clazz == null) {
                clazz = this.delegateToParent(name);
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return clazz;
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Object object;
        byte[] byArray;
        block11: {
            try {
                if (this.source != null) {
                    if (this.translator != null) {
                        this.translator.onLoad(this.source, name);
                    }
                    try {
                        byArray = this.source.get(name).toBytecode();
                        break block11;
                    }
                    catch (NotFoundException notFoundException) {
                        return null;
                    }
                }
                String string = "/" + name.replace('.', '/') + ".class";
                object = this.getClass().getResourceAsStream(string);
                if (object == null) {
                    return null;
                }
                byArray = ClassPoolTail.readStream((InputStream)object);
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("caught an exception while obtaining a class file for " + name, exception);
            }
        }
        int n2 = name.lastIndexOf(46);
        if (n2 != -1 && this.isDefinedPackage((String)(object = name.substring(0, n2)))) {
            try {
                this.definePackage((String)object, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if (this.domain == null) {
            return this.defineClass(name, byArray, 0, byArray.length);
        }
        return this.defineClass(name, byArray, 0, byArray.length, this.domain);
    }

    private boolean isDefinedPackage(String name) {
        if (ClassFile.MAJOR_VERSION >= 53) {
            return this.getDefinedPackage(name) == null;
        }
        return this.getPackage(name) == null;
    }

    protected Class<?> loadClassByDelegation(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (this.doDelegation && (name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("sun.") || name.startsWith("com.sun.") || name.startsWith("org.w3c.") || name.startsWith("org.xml.") || this.notDelegated(name))) {
            clazz = this.delegateToParent(name);
        }
        return clazz;
    }

    private boolean notDelegated(String name) {
        if (this.notDefinedHere.containsKey(name)) {
            return true;
        }
        for (String string : this.notDefinedPackages) {
            if (!name.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    protected Class<?> delegateToParent(String classname) throws ClassNotFoundException {
        ClassLoader classLoader = this.getParent();
        if (classLoader != null) {
            return classLoader.loadClass(classname);
        }
        return this.findSystemClass(classname);
    }

    public static class Simple
    extends ClassLoader {
        public Simple() {
        }

        public Simple(ClassLoader parent) {
            super(parent);
        }

        public Class<?> invokeDefineClass(CtClass cc) throws IOException, CannotCompileException {
            byte[] byArray = cc.toBytecode();
            return this.defineClass(cc.getName(), byArray, 0, byArray.length);
        }
    }
}

