/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist;

import ai.h2o.javassist.CannotCompileException;
import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.CtConstructor;
import ai.h2o.javassist.CtField;
import ai.h2o.javassist.CtMethod;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.Descriptor;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

public class SerialVersionUID {
    public static void setSerialVersionUID(CtClass clazz) throws CannotCompileException, NotFoundException {
        try {
            clazz.getDeclaredField("serialVersionUID");
            return;
        }
        catch (NotFoundException notFoundException) {
            if (!SerialVersionUID.isSerializable(clazz)) {
                return;
            }
            CtField ctField = new CtField(CtClass.longType, "serialVersionUID", clazz);
            ctField.setModifiers(26);
            clazz.addField(ctField, SerialVersionUID.calculateDefault(clazz) + "L");
            return;
        }
    }

    private static boolean isSerializable(CtClass clazz) throws NotFoundException {
        ClassPool classPool = clazz.getClassPool();
        return clazz.subtypeOf(classPool.get("java.io.Serializable"));
    }

    public static long calculateDefault(CtClass clazz) throws CannotCompileException {
        try {
            int n2;
            int n3;
            int n4;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            ClassFile classFile = clazz.getClassFile();
            String string = SerialVersionUID.javaName(clazz);
            dataOutputStream.writeUTF(string);
            CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
            int n5 = clazz.getModifiers();
            if ((n5 & 0x200) != 0) {
                n5 = ctMethodArray.length > 0 ? (n5 |= 0x400) : (n5 &= 0xFFFFFBFF);
            }
            dataOutputStream.writeInt(n5);
            Object[] objectArray = classFile.getInterfaces();
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                objectArray[n4] = SerialVersionUID.javaName((String)objectArray[n4]);
            }
            Arrays.sort(objectArray);
            for (n4 = 0; n4 < objectArray.length; ++n4) {
                dataOutputStream.writeUTF((String)objectArray[n4]);
            }
            CtField[] ctFieldArray = clazz.getDeclaredFields();
            Arrays.sort(ctFieldArray, new Comparator<CtField>(){

                @Override
                public int compare(CtField field1, CtField field2) {
                    return field1.getName().compareTo(field2.getName());
                }
            });
            for (int i2 = 0; i2 < ctFieldArray.length; ++i2) {
                CtField ctField = ctFieldArray[i2];
                int n6 = ctField.getModifiers();
                if ((n6 & 2) != 0 && (n6 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(ctField.getName());
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeUTF(ctField.getFieldInfo2().getDescriptor());
            }
            if (classFile.getStaticInitializer() != null) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            CtConstructor[] ctConstructorArray = clazz.getDeclaredConstructors();
            Arrays.sort(ctConstructorArray, new Comparator<CtConstructor>(){

                @Override
                public int compare(CtConstructor c1, CtConstructor c2) {
                    return c1.getMethodInfo2().getDescriptor().compareTo(c2.getMethodInfo2().getDescriptor());
                }
            });
            for (n3 = 0; n3 < ctConstructorArray.length; ++n3) {
                CtConstructor ctConstructor = ctConstructorArray[n3];
                n2 = ctConstructor.getModifiers();
                if ((n2 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(ctConstructor.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            Arrays.sort(ctMethodArray, new Comparator<CtMethod>(){

                @Override
                public int compare(CtMethod m1, CtMethod m2) {
                    int n2 = m1.getName().compareTo(m2.getName());
                    if (n2 == 0) {
                        n2 = m1.getMethodInfo2().getDescriptor().compareTo(m2.getMethodInfo2().getDescriptor());
                    }
                    return n2;
                }
            });
            for (n3 = 0; n3 < ctMethodArray.length; ++n3) {
                CtMethod ctMethod = ctMethodArray[n3];
                n2 = ctMethod.getModifiers() & 0xD3F;
                if ((n2 & 2) != 0) continue;
                dataOutputStream.writeUTF(ctMethod.getName());
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(ctMethod.getMethodInfo2().getDescriptor().replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l2 = 0L;
            for (int i3 = Math.min(byArray.length, 8) - 1; i3 >= 0; --i3) {
                l2 = l2 << 8 | (long)(byArray[i3] & 0xFF);
            }
            return l2;
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CannotCompileException(noSuchAlgorithmException);
        }
    }

    private static String javaName(CtClass clazz) {
        return Descriptor.toJavaName(Descriptor.toJvmName(clazz));
    }

    private static String javaName(String name) {
        return Descriptor.toJavaName(Descriptor.toJvmName(name));
    }
}

