/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.ExceptionTable;
import ai.h2o.javassist.bytecode.LineNumberAttribute;
import ai.h2o.javassist.bytecode.LocalVariableAttribute;
import ai.h2o.javassist.bytecode.Opcode;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import java.util.ArrayList;
import java.util.List;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    protected int mark;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 5, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    protected CodeIterator(CodeAttribute ca) {
        this.codeAttr = ca;
        this.bytecode = ca.getCode();
        this.begin();
    }

    public void begin() {
        CodeIterator codeIterator = this;
        codeIterator.mark = 0;
        codeIterator.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int index) {
        this.currentPos = index;
    }

    public void setMark(int index) {
        this.mark = index;
    }

    public int getMark() {
        return this.mark;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int index) {
        return this.bytecode[index] & 0xFF;
    }

    public int signedByteAt(int index) {
        return this.bytecode[index];
    }

    public void writeByte(int value, int index) {
        this.bytecode[index] = (byte)value;
    }

    public int u16bitAt(int index) {
        return ByteArray.readU16bit(this.bytecode, index);
    }

    public int s16bitAt(int index) {
        return ByteArray.readS16bit(this.bytecode, index);
    }

    public void write16bit(int value, int index) {
        ByteArray.write16bit(value, this.bytecode, index);
    }

    public int s32bitAt(int index) {
        return ByteArray.read32bit(this.bytecode, index);
    }

    public void write32bit(int value, int index) {
        ByteArray.write32bit(value, this.bytecode, index);
    }

    public void write(byte[] code, int index) {
        for (byte this.bytecode[index++] : code) {
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int n2 = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, n2);
        return n2;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int skipThis) throws BadBytecode {
        this.begin();
        ConstPool constPool = this.codeAttr.getConstPool();
        String string = this.codeAttr.getDeclaringClass();
        int n2 = 0;
        while (this.hasNext()) {
            int n3;
            int n4 = this.next();
            int n5 = this.byteAt(n4);
            if (n5 == 187) {
                ++n2;
                continue;
            }
            if (n5 != 183 || !constPool.getMethodrefName(n3 = ByteArray.readU16bit(this.bytecode, n4 + 1)).equals("<init>") || --n2 >= 0) continue;
            if (skipThis < 0) {
                return n4;
            }
            String string2 = constPool.getMethodrefClassName(n3);
            if (string2.equals(string) != skipThis > 0) break;
            return n4;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] code) throws BadBytecode {
        CodeIterator codeIterator = this;
        return codeIterator.insert0(codeIterator.currentPos, code, false);
    }

    public void insert(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, false);
    }

    public int insertAt(int pos, byte[] code) throws BadBytecode {
        return this.insert0(pos, code, false);
    }

    public int insertEx(byte[] code) throws BadBytecode {
        CodeIterator codeIterator = this;
        return codeIterator.insert0(codeIterator.currentPos, code, true);
    }

    public void insertEx(int pos, byte[] code) throws BadBytecode {
        this.insert0(pos, code, true);
    }

    public int insertExAt(int pos, byte[] code) throws BadBytecode {
        return this.insert0(pos, code, true);
    }

    private int insert0(int pos, byte[] code, boolean exclusive) throws BadBytecode {
        int n2 = code.length;
        if (n2 <= 0) {
            return pos;
        }
        int n3 = pos = this.insertGapAt((int)pos, (int)n2, (boolean)exclusive).position;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.bytecode[n3++] = code[i2];
        }
        return pos;
    }

    public int insertGap(int length) throws BadBytecode {
        CodeIterator codeIterator = this;
        return codeIterator.insertGapAt((int)codeIterator.currentPos, (int)length, (boolean)false).position;
    }

    public int insertGap(int pos, int length) throws BadBytecode {
        return this.insertGapAt((int)pos, (int)length, (boolean)false).length;
    }

    public int insertExGap(int length) throws BadBytecode {
        CodeIterator codeIterator = this;
        return codeIterator.insertGapAt((int)codeIterator.currentPos, (int)length, (boolean)true).position;
    }

    public int insertExGap(int pos, int length) throws BadBytecode {
        return this.insertGapAt((int)pos, (int)length, (boolean)true).length;
    }

    public Gap insertGapAt(int pos, int length, boolean exclusive) throws BadBytecode {
        int n2;
        byte[] byArray;
        Gap gap = new Gap();
        if (length <= 0) {
            gap.position = pos;
            gap.length = 0;
            return gap;
        }
        if (this.bytecode.length + length > Short.MAX_VALUE) {
            CodeIterator codeIterator = this;
            byArray = codeIterator.insertGapCore0w(codeIterator.bytecode, pos, length, exclusive, this.get().getExceptionTable(), this.codeAttr, gap);
            pos = gap.position;
            n2 = length;
        } else {
            int n3 = this.currentPos;
            byArray = CodeIterator.insertGapCore0(this.bytecode, pos, length, exclusive, this.get().getExceptionTable(), this.codeAttr);
            n2 = byArray.length - this.bytecode.length;
            gap.position = pos;
            gap.length = n2;
            if (n3 >= pos) {
                this.currentPos = n3 + n2;
            }
            if (this.mark > pos || this.mark == pos && exclusive) {
                this.mark += n2;
            }
        }
        this.codeAttr.setCode(byArray);
        this.bytecode = byArray;
        this.endPos = this.getCodeLength();
        this.updateCursors(pos, n2);
        return gap;
    }

    protected void updateCursors(int pos, int length) {
    }

    public void insert(ExceptionTable et, int offset) {
        this.codeAttr.getExceptionTable().add(0, et, offset);
    }

    public int append(byte[] code) {
        int n2 = this.getCodeLength();
        int n3 = code.length;
        if (n3 <= 0) {
            return n2;
        }
        this.appendGap(n3);
        byte[] byArray = this.bytecode;
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray[i2 + n2] = code[i2];
        }
        return n2;
    }

    public void appendGap(int gapLength) {
        int n2;
        byte[] byArray = this.bytecode;
        int n3 = this.bytecode.length;
        byte[] byArray2 = new byte[n3 + gapLength];
        for (n2 = 0; n2 < n3; ++n2) {
            byArray2[n2] = byArray[n2];
        }
        for (n2 = n3; n2 < n3 + gapLength; ++n2) {
            byArray2[n2] = 0;
        }
        this.codeAttr.setCode(byArray2);
        this.bytecode = byArray2;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable et, int offset) {
        ExceptionTable exceptionTable = this.codeAttr.getExceptionTable();
        exceptionTable.add(exceptionTable.size(), et, offset);
    }

    static int nextOpcode(byte[] code, int index) throws BadBytecode {
        int n2;
        block9: {
            try {
                n2 = code[index] & 0xFF;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new BadBytecode("invalid opcode address");
            }
            try {
                int n3 = opcodeLength[n2];
                if (n3 > 0) {
                    return index + n3;
                }
                if (n2 != 196) break block9;
                if (code[index + 1] == -124) {
                    return index + 6;
                }
                return index + 4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        int n4 = (index & 0xFFFFFFFC) + 8;
        if (n2 == 171) {
            int n5 = ByteArray.read32bit(code, n4);
            return n4 + (n5 << 3) + 4;
        }
        if (n2 == 170) {
            int n6 = ByteArray.read32bit(code, n4);
            int n7 = ByteArray.read32bit(code, n4 + 4);
            return n4 + (n7 - n6 + 1 << 2) + 8;
        }
        throw new BadBytecode(n2);
    }

    static byte[] insertGapCore0(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        try {
            return CodeIterator.insertGapCore1(code, where, gapLength, exclusive, etable, ca);
        }
        catch (AlignmentException alignmentException) {
            try {
                return CodeIterator.insertGapCore1(code, where, gapLength + 3 & 0xFFFFFFFC, exclusive, etable, ca);
            }
            catch (AlignmentException alignmentException2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGapCore1(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca) throws BadBytecode, AlignmentException {
        StackMap stackMap;
        StackMapTable stackMapTable;
        LocalVariableAttribute localVariableAttribute;
        LocalVariableAttribute localVariableAttribute2;
        int n2 = code.length;
        byte[] byArray = new byte[n2 + gapLength];
        CodeIterator.insertGap2(code, where, gapLength, n2, byArray, exclusive);
        etable.shiftPc(where, gapLength, exclusive);
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
        if (lineNumberAttribute != null) {
            lineNumberAttribute.shiftPc(where, gapLength, exclusive);
        }
        if ((localVariableAttribute2 = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable")) != null) {
            localVariableAttribute2.shiftPc(where, gapLength, exclusive);
        }
        if ((localVariableAttribute = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable")) != null) {
            localVariableAttribute.shiftPc(where, gapLength, exclusive);
        }
        if ((stackMapTable = (StackMapTable)ca.getAttribute("StackMapTable")) != null) {
            stackMapTable.shiftPc(where, gapLength, exclusive);
        }
        if ((stackMap = (StackMap)ca.getAttribute("StackMap")) != null) {
            stackMap.shiftPc(where, gapLength, exclusive);
        }
        return byArray;
    }

    private static void insertGap2(byte[] code, int where, int gapLength, int endPos, byte[] newcode, boolean exclusive) throws BadBytecode, AlignmentException {
        int n2 = 0;
        int n3 = 0;
        while (n2 < endPos) {
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            if (n2 == where) {
                n9 = n3 + gapLength;
                while (n3 < n9) {
                    newcode[n3++] = 0;
                }
            }
            int n10 = CodeIterator.nextOpcode(code, n2);
            n9 = code[n2] & 0xFF;
            if (153 <= n9 && n9 <= 168 || n9 == 198 || n9 == 199) {
                n8 = code[n2 + 1] << 8 | code[n2 + 2] & 0xFF;
                n8 = CodeIterator.newOffset(n2, n8, where, gapLength, exclusive);
                newcode[n3] = code[n2];
                ByteArray.write16bit(n8, newcode, n3 + 1);
                n3 += 3;
            } else if (n9 == 200 || n9 == 201) {
                n8 = ByteArray.read32bit(code, n2 + 1);
                n8 = CodeIterator.newOffset(n2, n8, where, gapLength, exclusive);
                newcode[n3++] = code[n2];
                ByteArray.write32bit(n8, newcode, n3);
                n3 += 4;
            } else if (n9 == 170) {
                if (n2 != n3 && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                n8 = (n2 & 0xFFFFFFFC) + 4;
                n3 = CodeIterator.copyGapBytes(newcode, n3, code, n2, n8);
                n7 = CodeIterator.newOffset(n2, ByteArray.read32bit(code, n8), where, gapLength, exclusive);
                ByteArray.write32bit(n7, newcode, n3);
                n6 = ByteArray.read32bit(code, n8 + 4);
                ByteArray.write32bit(n6, newcode, n3 + 4);
                n5 = ByteArray.read32bit(code, n8 + 8);
                ByteArray.write32bit(n5, newcode, n3 + 8);
                n3 += 12;
                n4 = n8 + 12;
                n8 = n4 + (n5 - n6 + 1 << 2);
                while (n4 < n8) {
                    int n11 = CodeIterator.newOffset(n2, ByteArray.read32bit(code, n4), where, gapLength, exclusive);
                    ByteArray.write32bit(n11, newcode, n3);
                    n3 += 4;
                    n4 += 4;
                }
            } else if (n9 == 171) {
                if (n2 != n3 && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                n8 = (n2 & 0xFFFFFFFC) + 4;
                n3 = CodeIterator.copyGapBytes(newcode, n3, code, n2, n8);
                n7 = CodeIterator.newOffset(n2, ByteArray.read32bit(code, n8), where, gapLength, exclusive);
                ByteArray.write32bit(n7, newcode, n3);
                n6 = ByteArray.read32bit(code, n8 + 4);
                ByteArray.write32bit(n6, newcode, n3 + 4);
                n3 += 8;
                n5 = n8 + 8;
                n8 = n5 + (n6 << 3);
                while (n5 < n8) {
                    ByteArray.copy32bit(code, n5, newcode, n3);
                    n4 = CodeIterator.newOffset(n2, ByteArray.read32bit(code, n5 + 4), where, gapLength, exclusive);
                    ByteArray.write32bit(n4, newcode, n3 + 4);
                    n3 += 8;
                    n5 += 8;
                }
            } else {
                while (n2 < n10) {
                    newcode[n3++] = code[n2++];
                }
            }
            n2 = n10;
        }
    }

    private static int copyGapBytes(byte[] newcode, int j2, byte[] code, int i2, int iEnd) {
        switch (iEnd - i2) {
            case 4: {
                newcode[j2++] = code[i2++];
            }
            case 3: {
                newcode[j2++] = code[i2++];
            }
            case 2: {
                newcode[j2++] = code[i2++];
            }
            case 1: {
                newcode[j2++] = code[i2];
            }
        }
        return j2;
    }

    private static int newOffset(int i2, int offset, int where, int gapLength, boolean exclusive) {
        int n2 = i2 + offset;
        if (i2 < where) {
            if (where < n2 || exclusive && where == n2) {
                offset += gapLength;
            }
        } else if (i2 == where ? n2 < where : n2 < where || !exclusive && where == n2) {
            offset -= gapLength;
        }
        return offset;
    }

    static byte[] changeLdcToLdcW(byte[] code, ExceptionTable etable, CodeAttribute ca, CodeAttribute.LdcEntry ldcs) throws BadBytecode {
        Pointers pointers = new Pointers(0, 0, 0, etable, ca);
        List<Branch> list = CodeIterator.makeJumpList(code, code.length, pointers);
        while (ldcs != null) {
            CodeIterator.addLdcW(ldcs, list);
            ldcs = ldcs.next;
        }
        byte[] byArray = CodeIterator.insertGap2w(code, 0, 0, false, list, pointers);
        return byArray;
    }

    private static void addLdcW(CodeAttribute.LdcEntry ldcs, List<Branch> jumps) {
        int n2 = ldcs.where;
        LdcW ldcW = new LdcW(n2, ldcs.index);
        int n3 = jumps.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (n2 >= jumps.get((int)i2).orgPos) continue;
            jumps.add(i2, ldcW);
            return;
        }
        jumps.add(ldcW);
    }

    private byte[] insertGapCore0w(byte[] code, int where, int gapLength, boolean exclusive, ExceptionTable etable, CodeAttribute ca, Gap newWhere) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        Pointers pointers = new Pointers(this.currentPos, this.mark, where, etable, ca);
        List<Branch> list = CodeIterator.makeJumpList(code, code.length, pointers);
        byte[] byArray = CodeIterator.insertGap2w(code, where, gapLength, exclusive, list, pointers);
        this.currentPos = pointers.cursor;
        this.mark = pointers.mark;
        int n2 = pointers.mark0;
        if (n2 == this.currentPos && !exclusive) {
            this.currentPos += gapLength;
        }
        if (exclusive) {
            n2 -= gapLength;
        }
        newWhere.position = n2;
        newWhere.length = gapLength;
        return byArray;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static byte[] insertGap2w(byte[] code, int where, int gapLength, boolean exclusive, List<Branch> jumps, Pointers ptrs) throws BadBytecode {
        if (gapLength > 0) {
            ptrs.shiftPc(where, gapLength, exclusive);
            for (Object var7_8 : jumps) {
                var7_8.shift(where, gapLength, exclusive);
            }
        }
        var6_7 = true;
        block1: while (true) {
            if (var6_7) {
                var6_7 = false;
                var7_8 = jumps.iterator();
                block2: while (true) {
                    if (!var7_8.hasNext()) continue block1;
                    var8_9 = var7_8.next();
                    if (!var8_9.expanded()) continue;
                    var6_7 = true;
                    var9_10 = var8_9.pos;
                    var10_11 = var8_9.deltaSize();
                    ptrs.shiftPc(var9_10, var10_11, false);
                    var11_12 = jumps.iterator();
                    while (true) {
                        if (var11_12.hasNext()) ** break;
                        continue block2;
                        var12_13 = var11_12.next();
                        var12_13.shift(var9_10, var10_11, false);
                    }
                    break;
                }
            }
            for (Branch var8_9 : jumps) {
                var9_10 = var8_9.gapChanged();
                if (var9_10 <= 0) continue;
                var6_7 = true;
                var10_11 = var8_9.pos;
                ptrs.shiftPc(var10_11, var9_10, false);
                for (Branch var12_13 : jumps) {
                    var12_13.shift(var10_11, var9_10, false);
                }
            }
            if (!var6_7) break;
        }
        return CodeIterator.makeExapndedCode(code, jumps, where, gapLength);
    }

    private static List<Branch> makeJumpList(byte[] code, int endPos, Pointers ptrs) throws BadBytecode {
        ArrayList<Branch> arrayList = new ArrayList<Branch>();
        int n2 = 0;
        while (n2 < endPos) {
            int n3;
            int n4;
            int n5;
            int n6 = CodeIterator.nextOpcode(code, n2);
            int n7 = code[n2] & 0xFF;
            if (153 <= n7 && n7 <= 168 || n7 == 198 || n7 == 199) {
                n5 = code[n2 + 1] << 8 | code[n2 + 2] & 0xFF;
                Branch16 branch16 = n7 == 167 || n7 == 168 ? new Jump16(n2, n5) : new If16(n2, n5);
                arrayList.add(branch16);
            } else if (n7 == 200 || n7 == 201) {
                n5 = ByteArray.read32bit(code, n2 + 1);
                arrayList.add(new Jump32(n2, n5));
            } else if (n7 == 170) {
                n5 = (n2 & 0xFFFFFFFC) + 4;
                int n8 = ByteArray.read32bit(code, n5);
                n4 = ByteArray.read32bit(code, n5 + 4);
                n3 = ByteArray.read32bit(code, n5 + 8);
                int n9 = n5 + 12;
                int n10 = n3 - n4 + 1;
                int[] nArray = new int[n10];
                for (int i2 = 0; i2 < n10; ++i2) {
                    nArray[i2] = ByteArray.read32bit(code, n9);
                    n9 += 4;
                }
                arrayList.add(new Table(n2, n8, n4, n3, nArray, ptrs));
            } else if (n7 == 171) {
                n5 = (n2 & 0xFFFFFFFC) + 4;
                int n11 = ByteArray.read32bit(code, n5);
                n4 = ByteArray.read32bit(code, n5 + 4);
                n3 = n5 + 8;
                int[] nArray = new int[n4];
                int[] nArray2 = new int[n4];
                for (int i3 = 0; i3 < n4; ++i3) {
                    nArray[i3] = ByteArray.read32bit(code, n3);
                    nArray2[i3] = ByteArray.read32bit(code, n3 + 4);
                    n3 += 8;
                }
                arrayList.add(new Lookup(n2, n11, nArray, nArray2, ptrs));
            }
            n2 = n6;
        }
        return arrayList;
    }

    private static byte[] makeExapndedCode(byte[] code, List<Branch> jumps, int where, int gapLength) throws BadBytecode {
        int n2;
        Branch branch;
        int n3 = jumps.size();
        int n4 = code.length + gapLength;
        for (Branch branch2 : jumps) {
            n4 += branch2.deltaSize();
        }
        Object object = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = code.length;
        if (n3 > 0) {
            branch = jumps.get(0);
            n2 = branch.orgPos;
        } else {
            branch = null;
            n2 = n8;
        }
        while (n5 < n8) {
            int n9;
            if (n5 == where) {
                n9 = n6 + gapLength;
                while (n6 < n9) {
                    object[n6++] = false;
                }
            }
            if (n5 != n2) {
                object[n6++] = code[n5++];
                continue;
            }
            n9 = branch.write(n5, code, n6, (byte[])object);
            n5 += n9;
            n6 += n9 + branch.deltaSize();
            if (++n7 < n3) {
                branch = jumps.get(n7);
                n2 = branch.orgPos;
                continue;
            }
            branch = null;
            n2 = n8;
        }
        return object;
    }

    static class Lookup
    extends Switcher {
        int[] matches;

        Lookup(int pos, int defaultByte, int[] matches, int[] offsets, Pointers ptrs) {
            super(pos, defaultByte, offsets, ptrs);
            this.matches = matches;
        }

        @Override
        int write2(int dest, byte[] newcode) {
            int n2 = this.matches.length;
            ByteArray.write32bit(n2, newcode, dest);
            dest += 4;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteArray.write32bit(this.matches[i2], newcode, dest);
                ByteArray.write32bit(this.offsets[i2], newcode, dest + 4);
                dest += 8;
            }
            return 4 + n2 * 8;
        }

        @Override
        int tableSize() {
            return 4 + 8 * this.matches.length;
        }
    }

    static class Table
    extends Switcher {
        int low;
        int high;

        Table(int pos, int defaultByte, int low, int high, int[] offsets, Pointers ptrs) {
            super(pos, defaultByte, offsets, ptrs);
            this.low = low;
            this.high = high;
        }

        @Override
        int write2(int dest, byte[] newcode) {
            ByteArray.write32bit(this.low, newcode, dest);
            ByteArray.write32bit(this.high, newcode, dest + 4);
            int n2 = this.offsets.length;
            dest += 8;
            for (int i2 = 0; i2 < n2; ++i2) {
                ByteArray.write32bit(this.offsets[i2], newcode, dest);
                dest += 4;
            }
            return 8 + 4 * n2;
        }

        @Override
        int tableSize() {
            return 8 + 4 * this.offsets.length;
        }
    }

    static abstract class Switcher
    extends Branch {
        int gap;
        int defaultByte;
        int[] offsets;
        Pointers pointers;

        Switcher(int pos, int defaultByte, int[] offsets, Pointers ptrs) {
            super(pos);
            this.gap = 3 - (pos & 3);
            this.defaultByte = defaultByte;
            this.offsets = offsets;
            this.pointers = ptrs;
        }

        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            int n2 = this.pos;
            this.defaultByte = Switcher.shiftOffset(n2, this.defaultByte, where, gapLength, exclusive);
            int n3 = this.offsets.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                this.offsets[i2] = Switcher.shiftOffset(n2, this.offsets[i2], where, gapLength, exclusive);
            }
            super.shift(where, gapLength, exclusive);
        }

        @Override
        int gapChanged() {
            int n2 = 3 - (this.pos & 3);
            if (n2 > this.gap) {
                int n3 = n2 - this.gap;
                this.gap = n2;
                return n3;
            }
            return 0;
        }

        @Override
        int deltaSize() {
            return this.gap - (3 - (this.orgPos & 3));
        }

        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) throws BadBytecode {
            int n2 = 3 - (this.pos & 3);
            int n3 = this.gap - n2;
            int n4 = 5 + (3 - (this.orgPos & 3)) + this.tableSize();
            if (n3 > 0) {
                this.adjustOffsets(n4, n3);
            }
            newcode[dest++] = code[src];
            while (n2-- > 0) {
                newcode[dest++] = 0;
            }
            ByteArray.write32bit(this.defaultByte, newcode, dest);
            int n5 = this.write2(dest + 4, newcode);
            dest += n5 + 4;
            while (n3-- > 0) {
                newcode[dest++] = 0;
            }
            return 5 + (3 - (this.orgPos & 3)) + n5;
        }

        abstract int write2(int var1, byte[] var2);

        abstract int tableSize();

        void adjustOffsets(int size, int nops) throws BadBytecode {
            this.pointers.shiftForSwitch(this.pos + size, nops);
            if (this.defaultByte == size) {
                this.defaultByte -= nops;
            }
            for (int i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2] != size) continue;
                int n2 = i2;
                this.offsets[n2] = this.offsets[n2] - nops;
            }
        }
    }

    static class Jump32
    extends Branch {
        int offset;

        Jump32(int p2, int off) {
            super(p2);
            this.offset = off;
        }

        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            this.offset = Jump32.shiftOffset(this.pos, this.offset, where, gapLength, exclusive);
            super.shift(where, gapLength, exclusive);
        }

        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = code[src];
            ByteArray.write32bit(this.offset, newcode, dest + 1);
            return 5;
        }
    }

    static class If16
    extends Branch16 {
        If16(int p2, int off) {
            super(p2, off);
        }

        @Override
        int deltaSize() {
            if (this.state == 2) {
                return 5;
            }
            return 0;
        }

        @Override
        void write32(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = (byte)this.opcode(code[src] & 0xFF);
            newcode[dest + 1] = 0;
            newcode[dest + 2] = 8;
            newcode[dest + 3] = -56;
            ByteArray.write32bit(this.offset - 3, newcode, dest + 4);
        }

        int opcode(int op) {
            if (op == 198) {
                return 199;
            }
            if (op == 199) {
                return 198;
            }
            if ((op - 153 & 1) == 0) {
                return op + 1;
            }
            return op - 1;
        }
    }

    static class Jump16
    extends Branch16 {
        Jump16(int p2, int off) {
            super(p2, off);
        }

        @Override
        int deltaSize() {
            if (this.state == 2) {
                return 2;
            }
            return 0;
        }

        @Override
        void write32(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = (byte)((code[src] & 0xFF) == 167 ? 200 : 201);
            ByteArray.write32bit(this.offset, newcode, dest + 1);
        }
    }

    static abstract class Branch16
    extends Branch {
        int offset;
        int state;
        static final int BIT16 = 0;
        static final int EXPAND = 1;
        static final int BIT32 = 2;

        Branch16(int p2, int off) {
            super(p2);
            this.offset = off;
            this.state = 0;
        }

        @Override
        void shift(int where, int gapLength, boolean exclusive) {
            this.offset = Branch16.shiftOffset(this.pos, this.offset, where, gapLength, exclusive);
            super.shift(where, gapLength, exclusive);
            if (this.state == 0 && (this.offset < Short.MIN_VALUE || Short.MAX_VALUE < this.offset)) {
                this.state = 1;
            }
        }

        @Override
        boolean expanded() {
            if (this.state == 1) {
                this.state = 2;
                return true;
            }
            return false;
        }

        @Override
        abstract int deltaSize();

        abstract void write32(int var1, byte[] var2, int var3, byte[] var4);

        @Override
        int write(int src, byte[] code, int dest, byte[] newcode) {
            if (this.state == 2) {
                this.write32(src, code, dest, newcode);
            } else {
                newcode[dest] = code[src];
                ByteArray.write16bit(this.offset, newcode, dest + 1);
            }
            return 3;
        }
    }

    static class LdcW
    extends Branch {
        int index;
        boolean state;

        LdcW(int p2, int i2) {
            super(p2);
            this.index = i2;
            this.state = true;
        }

        @Override
        boolean expanded() {
            if (this.state) {
                this.state = false;
                return true;
            }
            return false;
        }

        @Override
        int deltaSize() {
            return 1;
        }

        @Override
        int write(int srcPos, byte[] code, int destPos, byte[] newcode) {
            newcode[destPos] = 19;
            ByteArray.write16bit(this.index, newcode, destPos + 1);
            return 2;
        }
    }

    static abstract class Branch {
        int pos;
        int orgPos;

        Branch(int p2) {
            Branch branch = this;
            branch.pos = branch.orgPos = p2;
        }

        void shift(int where, int gapLength, boolean exclusive) {
            if (where < this.pos || where == this.pos && exclusive) {
                this.pos += gapLength;
            }
        }

        static int shiftOffset(int i2, int offset, int where, int gapLength, boolean exclusive) {
            block7: {
                block9: {
                    int n2;
                    block8: {
                        block6: {
                            n2 = i2 + offset;
                            if (i2 >= where) break block6;
                            if (where < n2 || exclusive && where == n2) {
                                offset += gapLength;
                            }
                            break block7;
                        }
                        if (i2 != where) break block8;
                        if (n2 < where && exclusive) break block9;
                        if (where < n2 && !exclusive) {
                            offset += gapLength;
                        }
                        break block7;
                    }
                    if (n2 >= where && (exclusive || where != n2)) break block7;
                }
                offset -= gapLength;
            }
            return offset;
        }

        boolean expanded() {
            return false;
        }

        int gapChanged() {
            return 0;
        }

        int deltaSize() {
            return 0;
        }

        abstract int write(int var1, byte[] var2, int var3, byte[] var4) throws BadBytecode;
    }

    static class Pointers {
        int cursor;
        int mark0;
        int mark;
        ExceptionTable etable;
        LineNumberAttribute line;
        LocalVariableAttribute vars;
        LocalVariableAttribute types;
        StackMapTable stack;
        StackMap stack2;

        Pointers(int cur, int m2, int m0, ExceptionTable et, CodeAttribute ca) {
            this.cursor = cur;
            this.mark = m2;
            this.mark0 = m0;
            this.etable = et;
            this.line = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
            this.vars = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
            this.types = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable");
            this.stack = (StackMapTable)ca.getAttribute("StackMapTable");
            this.stack2 = (StackMap)ca.getAttribute("StackMap");
        }

        void shiftPc(int where, int gapLength, boolean exclusive) throws BadBytecode {
            if (where < this.cursor || where == this.cursor && exclusive) {
                this.cursor += gapLength;
            }
            if (where < this.mark || where == this.mark && exclusive) {
                this.mark += gapLength;
            }
            if (where < this.mark0 || where == this.mark0 && exclusive) {
                this.mark0 += gapLength;
            }
            this.etable.shiftPc(where, gapLength, exclusive);
            if (this.line != null) {
                this.line.shiftPc(where, gapLength, exclusive);
            }
            if (this.vars != null) {
                this.vars.shiftPc(where, gapLength, exclusive);
            }
            if (this.types != null) {
                this.types.shiftPc(where, gapLength, exclusive);
            }
            if (this.stack != null) {
                this.stack.shiftPc(where, gapLength, exclusive);
            }
            if (this.stack2 != null) {
                this.stack2.shiftPc(where, gapLength, exclusive);
            }
        }

        void shiftForSwitch(int where, int gapLength) throws BadBytecode {
            if (this.stack != null) {
                this.stack.shiftForSwitch(where, gapLength);
            }
            if (this.stack2 != null) {
                this.stack2.shiftForSwitch(where, gapLength);
            }
        }
    }

    static class AlignmentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        AlignmentException() {
        }
    }

    public static class Gap {
        public int position;
        public int length;
    }
}

