/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.bytecode.ClassInfo;
import ai.h2o.javassist.bytecode.ConstInfo;
import ai.h2o.javassist.bytecode.ConstInfoPadding;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.DoubleInfo;
import ai.h2o.javassist.bytecode.FieldrefInfo;
import ai.h2o.javassist.bytecode.FloatInfo;
import ai.h2o.javassist.bytecode.IntegerInfo;
import ai.h2o.javassist.bytecode.InterfaceMethodrefInfo;
import ai.h2o.javassist.bytecode.InvokeDynamicInfo;
import ai.h2o.javassist.bytecode.LongInfo;
import ai.h2o.javassist.bytecode.LongVector;
import ai.h2o.javassist.bytecode.MemberrefInfo;
import ai.h2o.javassist.bytecode.MethodHandleInfo;
import ai.h2o.javassist.bytecode.MethodTypeInfo;
import ai.h2o.javassist.bytecode.MethodrefInfo;
import ai.h2o.javassist.bytecode.ModuleInfo;
import ai.h2o.javassist.bytecode.NameAndTypeInfo;
import ai.h2o.javassist.bytecode.PackageInfo;
import ai.h2o.javassist.bytecode.StringInfo;
import ai.h2o.javassist.bytecode.Utf8Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ConstPool {
    LongVector items;
    int numOfItems;
    int thisClassInfo;
    Map<ConstInfo, ConstInfo> itemsCache;
    public static final int CONST_Class = 7;
    public static final int CONST_Fieldref = 9;
    public static final int CONST_Methodref = 10;
    public static final int CONST_InterfaceMethodref = 11;
    public static final int CONST_String = 8;
    public static final int CONST_Integer = 3;
    public static final int CONST_Float = 4;
    public static final int CONST_Long = 5;
    public static final int CONST_Double = 6;
    public static final int CONST_NameAndType = 12;
    public static final int CONST_Utf8 = 1;
    public static final int CONST_MethodHandle = 15;
    public static final int CONST_MethodType = 16;
    public static final int CONST_InvokeDynamic = 18;
    public static final int CONST_Module = 19;
    public static final int CONST_Package = 20;
    public static final CtClass THIS = null;
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;

    public ConstPool(String thisclass) {
        this.items = new LongVector();
        this.itemsCache = null;
        this.numOfItems = 0;
        this.addItem0(null);
        this.thisClassInfo = this.addClassInfo(thisclass);
    }

    public ConstPool(DataInputStream in) throws IOException {
        this.itemsCache = null;
        this.thisClassInfo = 0;
        this.read(in);
    }

    final void prune() {
        this.itemsCache = null;
    }

    public final int getSize() {
        return this.numOfItems;
    }

    public final String getClassName() {
        ConstPool constPool = this;
        return constPool.getClassInfo(constPool.thisClassInfo);
    }

    public final int getThisClassInfo() {
        return this.thisClassInfo;
    }

    final void setThisClassInfo(int i2) {
        this.thisClassInfo = i2;
    }

    final ConstInfo getItem(int n2) {
        return this.items.elementAt(n2);
    }

    public final int getTag(int index) {
        return this.getItem(index).getTag();
    }

    public final String getClassInfo(int index) {
        ClassInfo classInfo = (ClassInfo)this.getItem(index);
        if (classInfo == null) {
            return null;
        }
        return Descriptor.toJavaName(this.getUtf8Info(classInfo.name));
    }

    public final String getClassInfoByDescriptor(int index) {
        ClassInfo classInfo = (ClassInfo)this.getItem(index);
        if (classInfo == null) {
            return null;
        }
        String string = this.getUtf8Info(classInfo.name);
        if (string.charAt(0) == '[') {
            return string;
        }
        return Descriptor.of(string);
    }

    public final int getNameAndTypeName(int index) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(index);
        return nameAndTypeInfo.memberName;
    }

    public final int getNameAndTypeDescriptor(int index) {
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(index);
        return nameAndTypeInfo.typeDescriptor;
    }

    public final int getMemberClass(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.classIndex;
    }

    public final int getMemberNameAndType(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.nameAndTypeIndex;
    }

    public final int getFieldrefClass(int index) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(index);
        return fieldrefInfo.classIndex;
    }

    public final String getFieldrefClassName(int index) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(index);
        if (fieldrefInfo == null) {
            return null;
        }
        return this.getClassInfo(fieldrefInfo.classIndex);
    }

    public final int getFieldrefNameAndType(int index) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(index);
        return fieldrefInfo.nameAndTypeIndex;
    }

    public final String getFieldrefName(int index) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(index);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public final String getFieldrefType(int index) {
        FieldrefInfo fieldrefInfo = (FieldrefInfo)this.getItem(index);
        if (fieldrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(fieldrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public final int getMethodrefClass(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.classIndex;
    }

    public final String getMethodrefClassName(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (memberrefInfo == null) {
            return null;
        }
        return this.getClassInfo(memberrefInfo.classIndex);
    }

    public final int getMethodrefNameAndType(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.nameAndTypeIndex;
    }

    public final String getMethodrefName(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public final String getMethodrefType(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public final int getInterfaceMethodrefClass(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.classIndex;
    }

    public final String getInterfaceMethodrefClassName(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return this.getClassInfo(memberrefInfo.classIndex);
    }

    public final int getInterfaceMethodrefNameAndType(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        return memberrefInfo.nameAndTypeIndex;
    }

    public final String getInterfaceMethodrefName(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.memberName);
    }

    public final String getInterfaceMethodrefType(int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (memberrefInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public final Object getLdcValue(int index) {
        ConstInfo constInfo = this.getItem(index);
        Object object = null;
        if (constInfo instanceof StringInfo) {
            object = this.getStringInfo(index);
        } else if (constInfo instanceof FloatInfo) {
            object = Float.valueOf(this.getFloatInfo(index));
        } else if (constInfo instanceof IntegerInfo) {
            object = this.getIntegerInfo(index);
        } else if (constInfo instanceof LongInfo) {
            object = this.getLongInfo(index);
        } else if (constInfo instanceof DoubleInfo) {
            object = this.getDoubleInfo(index);
        }
        return object;
    }

    public final int getIntegerInfo(int index) {
        IntegerInfo integerInfo = (IntegerInfo)this.getItem(index);
        return integerInfo.value;
    }

    public final float getFloatInfo(int index) {
        FloatInfo floatInfo = (FloatInfo)this.getItem(index);
        return floatInfo.value;
    }

    public final long getLongInfo(int index) {
        LongInfo longInfo = (LongInfo)this.getItem(index);
        return longInfo.value;
    }

    public final double getDoubleInfo(int index) {
        DoubleInfo doubleInfo = (DoubleInfo)this.getItem(index);
        return doubleInfo.value;
    }

    public final String getStringInfo(int index) {
        StringInfo stringInfo = (StringInfo)this.getItem(index);
        return this.getUtf8Info(stringInfo.string);
    }

    public final String getUtf8Info(int index) {
        Utf8Info utf8Info = (Utf8Info)this.getItem(index);
        return utf8Info.string;
    }

    public final int getMethodHandleKind(int index) {
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)this.getItem(index);
        return methodHandleInfo.refKind;
    }

    public final int getMethodHandleIndex(int index) {
        MethodHandleInfo methodHandleInfo = (MethodHandleInfo)this.getItem(index);
        return methodHandleInfo.refIndex;
    }

    public final int getMethodTypeInfo(int index) {
        MethodTypeInfo methodTypeInfo = (MethodTypeInfo)this.getItem(index);
        return methodTypeInfo.descriptor;
    }

    public final int getInvokeDynamicBootstrap(int index) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)this.getItem(index);
        return invokeDynamicInfo.bootstrap;
    }

    public final int getInvokeDynamicNameAndType(int index) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)this.getItem(index);
        return invokeDynamicInfo.nameAndType;
    }

    public final String getInvokeDynamicType(int index) {
        InvokeDynamicInfo invokeDynamicInfo = (InvokeDynamicInfo)this.getItem(index);
        if (invokeDynamicInfo == null) {
            return null;
        }
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(invokeDynamicInfo.nameAndType);
        if (nameAndTypeInfo == null) {
            return null;
        }
        return this.getUtf8Info(nameAndTypeInfo.typeDescriptor);
    }

    public final String getModuleInfo(int index) {
        ModuleInfo moduleInfo = (ModuleInfo)this.getItem(index);
        return this.getUtf8Info(moduleInfo.name);
    }

    public final String getPackageInfo(int index) {
        PackageInfo packageInfo = (PackageInfo)this.getItem(index);
        return this.getUtf8Info(packageInfo.name);
    }

    public final int isConstructor(String classname, int index) {
        return this.isMember(classname, "<init>", index);
    }

    public final int isMember(String classname, String membername, int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        if (this.getClassInfo(memberrefInfo.classIndex).equals(classname)) {
            NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
            if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(membername)) {
                return nameAndTypeInfo.typeDescriptor;
            }
        }
        return 0;
    }

    public final String eqMember(String membername, String desc, int index) {
        MemberrefInfo memberrefInfo = (MemberrefInfo)this.getItem(index);
        NameAndTypeInfo nameAndTypeInfo = (NameAndTypeInfo)this.getItem(memberrefInfo.nameAndTypeIndex);
        if (this.getUtf8Info(nameAndTypeInfo.memberName).equals(membername) && this.getUtf8Info(nameAndTypeInfo.typeDescriptor).equals(desc)) {
            return this.getClassInfo(memberrefInfo.classIndex);
        }
        return null;
    }

    private int addItem0(ConstInfo info) {
        this.items.addElement(info);
        return this.numOfItems++;
    }

    private int addItem(ConstInfo info) {
        ConstInfo constInfo;
        if (this.itemsCache == null) {
            this.itemsCache = ConstPool.makeItemsCache(this.items);
        }
        if ((constInfo = this.itemsCache.get(info)) != null) {
            return constInfo.index;
        }
        this.items.addElement(info);
        ConstInfo constInfo2 = info;
        this.itemsCache.put(constInfo2, constInfo2);
        return this.numOfItems++;
    }

    public final int copy(int n2, ConstPool dest, Map<String, String> classnames) {
        if (n2 == 0) {
            return 0;
        }
        ConstInfo constInfo = this.getItem(n2);
        return constInfo.copy(this, dest, classnames);
    }

    final int addConstInfoPadding() {
        return this.addItem0(new ConstInfoPadding(this.numOfItems));
    }

    public final int addClassInfo(CtClass c2) {
        if (c2 == THIS) {
            return this.thisClassInfo;
        }
        if (!c2.isArray()) {
            return this.addClassInfo(c2.getName());
        }
        return this.addClassInfo(Descriptor.toJvmName(c2));
    }

    public final int addClassInfo(String qname) {
        int n2 = this.addUtf8Info(Descriptor.toJvmName(qname));
        return this.addItem(new ClassInfo(n2, this.numOfItems));
    }

    public final int addNameAndTypeInfo(String name, String type) {
        ConstPool constPool = this;
        return constPool.addNameAndTypeInfo(constPool.addUtf8Info(name), this.addUtf8Info(type));
    }

    public final int addNameAndTypeInfo(int name, int type) {
        return this.addItem(new NameAndTypeInfo(name, type, this.numOfItems));
    }

    public final int addFieldrefInfo(int classInfo, String name, String type) {
        int n2 = this.addNameAndTypeInfo(name, type);
        return this.addFieldrefInfo(classInfo, n2);
    }

    public final int addFieldrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new FieldrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public final int addMethodrefInfo(int classInfo, String name, String type) {
        int n2 = this.addNameAndTypeInfo(name, type);
        return this.addMethodrefInfo(classInfo, n2);
    }

    public final int addMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new MethodrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public final int addInterfaceMethodrefInfo(int classInfo, String name, String type) {
        int n2 = this.addNameAndTypeInfo(name, type);
        return this.addInterfaceMethodrefInfo(classInfo, n2);
    }

    public final int addInterfaceMethodrefInfo(int classInfo, int nameAndTypeInfo) {
        return this.addItem(new InterfaceMethodrefInfo(classInfo, nameAndTypeInfo, this.numOfItems));
    }

    public final int addStringInfo(String str) {
        int n2 = this.addUtf8Info(str);
        return this.addItem(new StringInfo(n2, this.numOfItems));
    }

    public final int addIntegerInfo(int i2) {
        return this.addItem(new IntegerInfo(i2, this.numOfItems));
    }

    public final int addFloatInfo(float f2) {
        return this.addItem(new FloatInfo(f2, this.numOfItems));
    }

    public final int addLongInfo(long l2) {
        int n2 = this.addItem(new LongInfo(l2, this.numOfItems));
        if (n2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n2;
    }

    public final int addDoubleInfo(double d2) {
        int n2 = this.addItem(new DoubleInfo(d2, this.numOfItems));
        if (n2 == this.numOfItems - 1) {
            this.addConstInfoPadding();
        }
        return n2;
    }

    public final int addUtf8Info(String utf8) {
        return this.addItem(new Utf8Info(utf8, this.numOfItems));
    }

    public final int addMethodHandleInfo(int kind, int index) {
        return this.addItem(new MethodHandleInfo(kind, index, this.numOfItems));
    }

    public final int addMethodTypeInfo(int desc) {
        return this.addItem(new MethodTypeInfo(desc, this.numOfItems));
    }

    public final int addInvokeDynamicInfo(int bootstrap, int nameAndType) {
        return this.addItem(new InvokeDynamicInfo(bootstrap, nameAndType, this.numOfItems));
    }

    public final int addModuleInfo(int nameIndex) {
        return this.addItem(new ModuleInfo(nameIndex, this.numOfItems));
    }

    public final int addPackageInfo(int nameIndex) {
        return this.addItem(new PackageInfo(nameIndex, this.numOfItems));
    }

    public final Set<String> getClassNames() {
        HashSet<String> hashSet = new HashSet<String>();
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            String string = longVector.elementAt(i2).getClassName(this);
            if (string == null) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public final void renameClass(String oldName, String newName) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            ConstInfo constInfo = longVector.elementAt(i2);
            constInfo.renameClass(this, oldName, newName, this.itemsCache);
        }
    }

    public final void renameClass(Map<String, String> classnames) {
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            ConstInfo constInfo = longVector.elementAt(i2);
            constInfo.renameClass(this, classnames, this.itemsCache);
        }
    }

    private void read(DataInputStream in) throws IOException {
        int n2 = in.readUnsignedShort();
        this.items = new LongVector(n2);
        this.numOfItems = 0;
        this.addItem0(null);
        while (--n2 > 0) {
            int n3 = this.readOne(in);
            if (n3 != 5 && n3 != 6) continue;
            this.addConstInfoPadding();
            --n2;
        }
    }

    private static Map<ConstInfo, ConstInfo> makeItemsCache(LongVector items) {
        ConstInfo constInfo;
        HashMap<ConstInfo, ConstInfo> hashMap = new HashMap<ConstInfo, ConstInfo>();
        int n2 = 1;
        while ((constInfo = items.elementAt(n2++)) != null) {
            ConstInfo constInfo2 = constInfo;
            hashMap.put(constInfo2, constInfo2);
        }
        return hashMap;
    }

    private int readOne(DataInputStream in) throws IOException {
        ConstInfo constInfo;
        int n2 = in.readUnsignedByte();
        switch (n2) {
            case 1: {
                constInfo = new Utf8Info(in, this.numOfItems);
                break;
            }
            case 3: {
                constInfo = new IntegerInfo(in, this.numOfItems);
                break;
            }
            case 4: {
                constInfo = new FloatInfo(in, this.numOfItems);
                break;
            }
            case 5: {
                constInfo = new LongInfo(in, this.numOfItems);
                break;
            }
            case 6: {
                constInfo = new DoubleInfo(in, this.numOfItems);
                break;
            }
            case 7: {
                constInfo = new ClassInfo(in, this.numOfItems);
                break;
            }
            case 8: {
                constInfo = new StringInfo(in, this.numOfItems);
                break;
            }
            case 9: {
                constInfo = new FieldrefInfo(in, this.numOfItems);
                break;
            }
            case 10: {
                constInfo = new MethodrefInfo(in, this.numOfItems);
                break;
            }
            case 11: {
                constInfo = new InterfaceMethodrefInfo(in, this.numOfItems);
                break;
            }
            case 12: {
                constInfo = new NameAndTypeInfo(in, this.numOfItems);
                break;
            }
            case 15: {
                constInfo = new MethodHandleInfo(in, this.numOfItems);
                break;
            }
            case 16: {
                constInfo = new MethodTypeInfo(in, this.numOfItems);
                break;
            }
            case 18: {
                constInfo = new InvokeDynamicInfo(in, this.numOfItems);
                break;
            }
            case 19: {
                constInfo = new ModuleInfo(in, this.numOfItems);
                break;
            }
            case 20: {
                constInfo = new PackageInfo(in, this.numOfItems);
                break;
            }
            default: {
                throw new IOException("invalid constant type: " + n2 + " at " + this.numOfItems);
            }
        }
        this.addItem0(constInfo);
        return n2;
    }

    public final void write(DataOutputStream out) throws IOException {
        out.writeShort(this.numOfItems);
        LongVector longVector = this.items;
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            longVector.elementAt(i2).write(out);
        }
    }

    public final void print() {
        this.print(new PrintWriter(System.out, true));
    }

    public final void print(PrintWriter out) {
        int n2 = this.numOfItems;
        for (int i2 = 1; i2 < n2; ++i2) {
            out.print(i2);
            out.print(" ");
            this.items.elementAt(i2).print(out);
        }
    }
}

