/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.bytecode.AnnotationDefaultAttribute;
import ai.h2o.javassist.bytecode.AttributeInfo;
import ai.h2o.javassist.bytecode.BadBytecode;
import ai.h2o.javassist.bytecode.ByteArray;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.CodeAttribute;
import ai.h2o.javassist.bytecode.CodeIterator;
import ai.h2o.javassist.bytecode.ConstPool;
import ai.h2o.javassist.bytecode.Descriptor;
import ai.h2o.javassist.bytecode.ExceptionsAttribute;
import ai.h2o.javassist.bytecode.LineNumberAttribute;
import ai.h2o.javassist.bytecode.StackMap;
import ai.h2o.javassist.bytecode.StackMapTable;
import ai.h2o.javassist.bytecode.stackmap.MapMaker;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MethodInfo {
    ConstPool constPool;
    int accessFlags;
    int name;
    String cachedName;
    int descriptor;
    List<AttributeInfo> attribute;
    public static boolean doPreverify = false;
    public static final String nameInit = "<init>";
    public static final String nameClinit = "<clinit>";

    private MethodInfo(ConstPool cp) {
        this.constPool = cp;
        this.attribute = null;
    }

    public MethodInfo(ConstPool cp, String methodname, String desc) {
        this(cp);
        this.accessFlags = 0;
        this.name = cp.addUtf8Info(methodname);
        this.cachedName = methodname;
        this.descriptor = this.constPool.addUtf8Info(desc);
    }

    MethodInfo(ConstPool cp, DataInputStream in) throws IOException {
        this(cp);
        this.read(in);
    }

    public MethodInfo(ConstPool cp, String methodname, MethodInfo src, Map<String, String> classnameMap) throws BadBytecode {
        this(cp);
        this.read(src, methodname, classnameMap);
    }

    public String toString() {
        return this.getName() + " " + this.getDescriptor();
    }

    void compact(ConstPool cp) {
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.attribute = AttributeInfo.copyAll(this.attribute, cp);
        this.constPool = cp;
    }

    void prune(ConstPool cp) {
        AttributeInfo attributeInfo;
        ExceptionsAttribute exceptionsAttribute;
        AnnotationDefaultAttribute annotationDefaultAttribute;
        AttributeInfo attributeInfo2;
        AttributeInfo attributeInfo3;
        AttributeInfo attributeInfo4;
        ArrayList<AttributeInfo> arrayList = new ArrayList<AttributeInfo>();
        AttributeInfo attributeInfo5 = this.getAttribute("RuntimeInvisibleAnnotations");
        if (attributeInfo5 != null) {
            attributeInfo5 = attributeInfo5.copy(cp, null);
            arrayList.add(attributeInfo5);
        }
        if ((attributeInfo4 = this.getAttribute("RuntimeVisibleAnnotations")) != null) {
            attributeInfo4 = attributeInfo4.copy(cp, null);
            arrayList.add(attributeInfo4);
        }
        if ((attributeInfo3 = this.getAttribute("RuntimeInvisibleParameterAnnotations")) != null) {
            attributeInfo3 = attributeInfo3.copy(cp, null);
            arrayList.add(attributeInfo3);
        }
        if ((attributeInfo2 = this.getAttribute("RuntimeVisibleParameterAnnotations")) != null) {
            attributeInfo2 = attributeInfo2.copy(cp, null);
            arrayList.add(attributeInfo2);
        }
        if ((annotationDefaultAttribute = (AnnotationDefaultAttribute)this.getAttribute("AnnotationDefault")) != null) {
            arrayList.add(annotationDefaultAttribute);
        }
        if ((exceptionsAttribute = this.getExceptionsAttribute()) != null) {
            arrayList.add(exceptionsAttribute);
        }
        if ((attributeInfo = this.getAttribute("Signature")) != null) {
            attributeInfo = attributeInfo.copy(cp, null);
            arrayList.add(attributeInfo);
        }
        this.attribute = arrayList;
        this.name = cp.addUtf8Info(this.getName());
        this.descriptor = cp.addUtf8Info(this.getDescriptor());
        this.constPool = cp;
    }

    public String getName() {
        if (this.cachedName == null) {
            this.cachedName = this.constPool.getUtf8Info(this.name);
        }
        return this.cachedName;
    }

    public void setName(String newName) {
        this.name = this.constPool.addUtf8Info(newName);
        this.cachedName = newName;
    }

    public boolean isMethod() {
        String string = this.getName();
        return !string.equals(nameInit) && !string.equals(nameClinit);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public boolean isConstructor() {
        return this.getName().equals(nameInit);
    }

    public boolean isStaticInitializer() {
        return this.getName().equals(nameClinit);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int acc) {
        this.accessFlags = acc;
    }

    public String getDescriptor() {
        return this.constPool.getUtf8Info(this.descriptor);
    }

    public void setDescriptor(String desc) {
        if (!desc.equals(this.getDescriptor())) {
            this.descriptor = this.constPool.addUtf8Info(desc);
        }
    }

    public List<AttributeInfo> getAttributes() {
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        return this.attribute;
    }

    public AttributeInfo getAttribute(String name) {
        return AttributeInfo.lookup(this.attribute, name);
    }

    public AttributeInfo removeAttribute(String name) {
        return AttributeInfo.remove(this.attribute, name);
    }

    public void addAttribute(AttributeInfo info) {
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        AttributeInfo.remove(this.attribute, info.getName());
        this.attribute.add(info);
    }

    public ExceptionsAttribute getExceptionsAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(this.attribute, "Exceptions");
        return (ExceptionsAttribute)attributeInfo;
    }

    public CodeAttribute getCodeAttribute() {
        AttributeInfo attributeInfo = AttributeInfo.lookup(this.attribute, "Code");
        return (CodeAttribute)attributeInfo;
    }

    public void removeExceptionsAttribute() {
        AttributeInfo.remove(this.attribute, "Exceptions");
    }

    public void setExceptionsAttribute(ExceptionsAttribute cattr) {
        this.removeExceptionsAttribute();
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        this.attribute.add(cattr);
    }

    public void removeCodeAttribute() {
        AttributeInfo.remove(this.attribute, "Code");
    }

    public void setCodeAttribute(CodeAttribute cattr) {
        this.removeCodeAttribute();
        if (this.attribute == null) {
            this.attribute = new ArrayList<AttributeInfo>();
        }
        this.attribute.add(cattr);
    }

    public void rebuildStackMapIf6(ClassPool pool, ClassFile cf) throws BadBytecode {
        if (cf.getMajorVersion() >= 50) {
            this.rebuildStackMap(pool);
        }
        if (doPreverify) {
            this.rebuildStackMapForME(pool);
        }
    }

    public void rebuildStackMap(ClassPool pool) throws BadBytecode {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute != null) {
            StackMapTable stackMapTable = MapMaker.make(pool, this);
            codeAttribute.setAttribute(stackMapTable);
        }
    }

    public void rebuildStackMapForME(ClassPool pool) throws BadBytecode {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute != null) {
            StackMap stackMap = MapMaker.make2(pool, this);
            codeAttribute.setAttribute(stackMap);
        }
    }

    public int getLineNumber(int pos) {
        CodeAttribute codeAttribute = this.getCodeAttribute();
        if (codeAttribute == null) {
            return -1;
        }
        LineNumberAttribute lineNumberAttribute = (LineNumberAttribute)codeAttribute.getAttribute("LineNumberTable");
        if (lineNumberAttribute == null) {
            return -1;
        }
        return lineNumberAttribute.toLineNumber(pos);
    }

    public void setSuperclass(String superclass) throws BadBytecode {
        if (!this.isConstructor()) {
            return;
        }
        CodeAttribute codeAttribute = this.getCodeAttribute();
        byte[] byArray = codeAttribute.getCode();
        CodeIterator codeIterator = codeAttribute.iterator();
        int n2 = codeIterator.skipSuperConstructor();
        if (n2 >= 0) {
            ConstPool constPool = this.constPool;
            int n3 = ByteArray.readU16bit(byArray, n2 + 1);
            int n4 = constPool.getMethodrefNameAndType(n3);
            int n5 = constPool.addClassInfo(superclass);
            int n6 = constPool.addMethodrefInfo(n5, n4);
            ByteArray.write16bit(n6, byArray, n2 + 1);
        }
    }

    private void read(MethodInfo src, String methodname, Map<String, String> classnames) {
        CodeAttribute codeAttribute;
        ConstPool constPool = this.constPool;
        this.accessFlags = src.accessFlags;
        this.name = constPool.addUtf8Info(methodname);
        this.cachedName = methodname;
        ConstPool constPool2 = src.constPool;
        String string = constPool2.getUtf8Info(src.descriptor);
        String string2 = Descriptor.rename(string, classnames);
        this.descriptor = constPool.addUtf8Info(string2);
        this.attribute = new ArrayList<AttributeInfo>();
        ExceptionsAttribute exceptionsAttribute = src.getExceptionsAttribute();
        if (exceptionsAttribute != null) {
            this.attribute.add(exceptionsAttribute.copy(constPool, classnames));
        }
        if ((codeAttribute = src.getCodeAttribute()) != null) {
            this.attribute.add(codeAttribute.copy(constPool, classnames));
        }
    }

    private void read(DataInputStream in) throws IOException {
        this.accessFlags = in.readUnsignedShort();
        this.name = in.readUnsignedShort();
        this.descriptor = in.readUnsignedShort();
        int n2 = in.readUnsignedShort();
        this.attribute = new ArrayList<AttributeInfo>();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.attribute.add(AttributeInfo.read(this.constPool, in));
        }
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.accessFlags);
        out.writeShort(this.name);
        out.writeShort(this.descriptor);
        if (this.attribute == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(this.attribute.size());
        AttributeInfo.writeAll(this.attribute, out);
    }
}

