/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.analysis;

import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.bytecode.analysis.Type;
import java.util.HashMap;
import java.util.Map;

public class MultiType
extends Type {
    private Map<String, CtClass> interfaces;
    private Type resolved;
    private Type potentialClass;
    private MultiType mergeSource;
    private boolean changed = false;

    public MultiType(Map<String, CtClass> interfaces) {
        this(interfaces, null);
    }

    public MultiType(Map<String, CtClass> interfaces, Type potentialClass) {
        super(null);
        this.interfaces = interfaces;
        this.potentialClass = potentialClass;
    }

    @Override
    public CtClass getCtClass() {
        if (this.resolved != null) {
            return this.resolved.getCtClass();
        }
        return Type.OBJECT.getCtClass();
    }

    @Override
    public Type getComponent() {
        return null;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    boolean popChanged() {
        boolean bl = this.changed;
        this.changed = false;
        return bl;
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isAssignableTo(Type type) {
        if (this.resolved != null) {
            return type.isAssignableFrom(this.resolved);
        }
        if (Type.OBJECT.equals(type)) {
            return true;
        }
        if (this.potentialClass != null && !type.isAssignableFrom(this.potentialClass)) {
            this.potentialClass = null;
        }
        MultiType multiType = this;
        Map<String, CtClass> map = multiType.mergeMultiAndSingle(multiType, type);
        if (map.size() == 1 && this.potentialClass == null) {
            this.resolved = Type.get(map.values().iterator().next());
            this.propogateResolved();
            return true;
        }
        if (map.size() > 0) {
            this.interfaces = map;
            this.propogateState();
            return true;
        }
        if (this.potentialClass != null) {
            this.resolved = this.potentialClass;
            this.propogateResolved();
            return true;
        }
        return false;
    }

    private void propogateState() {
        MultiType multiType = this.mergeSource;
        while (multiType != null) {
            multiType.interfaces = this.interfaces;
            multiType.potentialClass = this.potentialClass;
            multiType = multiType.mergeSource;
        }
    }

    private void propogateResolved() {
        MultiType multiType = this.mergeSource;
        while (multiType != null) {
            multiType.resolved = this.resolved;
            multiType = multiType.mergeSource;
        }
    }

    @Override
    public boolean isReference() {
        return true;
    }

    private Map<String, CtClass> getAllMultiInterfaces(MultiType type) {
        HashMap<String, CtClass> hashMap = new HashMap<String, CtClass>();
        for (CtClass ctClass : type.interfaces.values()) {
            hashMap.put(ctClass.getName(), ctClass);
            this.getAllInterfaces(ctClass, hashMap);
        }
        return hashMap;
    }

    private Map<String, CtClass> mergeMultiInterfaces(MultiType type1, MultiType type2) {
        Map<String, CtClass> map = this.getAllMultiInterfaces(type1);
        Map<String, CtClass> map2 = this.getAllMultiInterfaces(type2);
        return this.findCommonInterfaces(map, map2);
    }

    private Map<String, CtClass> mergeMultiAndSingle(MultiType multi, Type single) {
        Map<String, CtClass> map = this.getAllMultiInterfaces(multi);
        Map<String, CtClass> map2 = this.getAllInterfaces(single.getCtClass(), null);
        return this.findCommonInterfaces(map, map2);
    }

    private boolean inMergeSource(MultiType source) {
        while (source != null) {
            if (source == this) {
                return true;
            }
            source = source.mergeSource;
        }
        return false;
    }

    @Override
    public Type merge(Type type) {
        Map<String, CtClass> map;
        if (this == type) {
            return this;
        }
        if (type == UNINIT) {
            return this;
        }
        if (type == BOGUS) {
            return BOGUS;
        }
        if (type == null) {
            return this;
        }
        if (this.resolved != null) {
            return this.resolved.merge(type);
        }
        if (this.potentialClass != null && (!((Type)((Object)(map = this.potentialClass.merge(type)))).equals(this.potentialClass) || ((Type)((Object)map)).popChanged())) {
            this.potentialClass = Type.OBJECT.equals(map) ? null : map;
            this.changed = true;
        }
        if (type instanceof MultiType) {
            MultiType multiType = (MultiType)type;
            if (multiType.resolved != null) {
                MultiType multiType2 = this;
                map = multiType2.mergeMultiAndSingle(multiType2, multiType.resolved);
            } else {
                map = this.mergeMultiInterfaces(multiType, this);
                if (!this.inMergeSource(multiType)) {
                    this.mergeSource = multiType;
                }
            }
        } else {
            MultiType multiType = this;
            map = multiType.mergeMultiAndSingle(multiType, type);
        }
        if (map.size() > 1 || map.size() == 1 && this.potentialClass != null) {
            if (map.size() != this.interfaces.size()) {
                this.changed = true;
            } else if (!this.changed) {
                for (String string : map.keySet()) {
                    if (this.interfaces.containsKey(string)) continue;
                    this.changed = true;
                }
            }
            this.interfaces = map;
            this.propogateState();
            return this;
        }
        this.resolved = map.size() == 1 ? Type.get(map.values().iterator().next()) : (this.potentialClass != null ? this.potentialClass : OBJECT);
        this.propogateResolved();
        return this.resolved;
    }

    @Override
    public int hashCode() {
        if (this.resolved != null) {
            return this.resolved.hashCode();
        }
        return this.interfaces.keySet().hashCode();
    }

    @Override
    public boolean equals(Object o2) {
        if (!(o2 instanceof MultiType)) {
            return false;
        }
        MultiType multiType = (MultiType)o2;
        if (this.resolved != null) {
            return this.resolved.equals(multiType.resolved);
        }
        if (multiType.resolved != null) {
            return false;
        }
        return this.interfaces.keySet().equals(multiType.interfaces.keySet());
    }

    @Override
    public String toString() {
        if (this.resolved != null) {
            return this.resolved.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("{");
        for (String string : this.interfaces.keySet()) {
            stringBuffer.append(string).append(", ");
        }
        if (this.potentialClass != null) {
            stringBuffer.append("*").append(this.potentialClass.toString());
        } else {
            StringBuffer stringBuffer2 = stringBuffer;
            stringBuffer2.setLength(stringBuffer2.length() - 2);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

