/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.javassist.bytecode.annotation;

import ai.h2o.javassist.ClassPool;
import ai.h2o.javassist.CtClass;
import ai.h2o.javassist.NotFoundException;
import ai.h2o.javassist.bytecode.AnnotationDefaultAttribute;
import ai.h2o.javassist.bytecode.ClassFile;
import ai.h2o.javassist.bytecode.MethodInfo;
import ai.h2o.javassist.bytecode.annotation.Annotation;
import ai.h2o.javassist.bytecode.annotation.MemberValue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class AnnotationImpl
implements InvocationHandler {
    private static final String JDK_ANNOTATION_CLASS_NAME = "java.lang.annotation.Annotation";
    private static Method JDK_ANNOTATION_TYPE_METHOD = null;
    private Annotation annotation;
    private ClassPool pool;
    private ClassLoader classLoader;
    private transient Class<?> annotationType;
    private transient int cachedHashCode = Integer.MIN_VALUE;

    public static Object make(ClassLoader cl, Class<?> clazz, ClassPool cp, Annotation anon) throws IllegalArgumentException {
        AnnotationImpl annotationImpl = new AnnotationImpl(anon, cp, cl);
        return Proxy.newProxyInstance(cl, new Class[]{clazz}, (InvocationHandler)annotationImpl);
    }

    private AnnotationImpl(Annotation a2, ClassPool cp, ClassLoader loader) {
        this.annotation = a2;
        this.pool = cp;
        this.classLoader = loader;
    }

    public String getTypeName() {
        return this.annotation.getTypeName();
    }

    private Class<?> getAnnotationType() {
        if (this.annotationType == null) {
            String string = this.annotation.getTypeName();
            try {
                this.annotationType = this.classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError("Error loading annotation class: " + string);
                noClassDefFoundError.setStackTrace(classNotFoundException.getStackTrace());
                throw noClassDefFoundError;
            }
        }
        return this.annotationType;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MemberValue memberValue;
        String string = method.getName();
        if (Object.class == method.getDeclaringClass()) {
            if ("equals".equals(string)) {
                Object object = args[0];
                return this.checkEquals(object);
            }
            if ("toString".equals(string)) {
                return this.annotation.toString();
            }
            if ("hashCode".equals(string)) {
                return this.hashCode();
            }
        } else if ("annotationType".equals(string) && method.getParameterTypes().length == 0) {
            return this.getAnnotationType();
        }
        if ((memberValue = this.annotation.getMemberValue(string)) == null) {
            return this.getDefault(string, method);
        }
        return memberValue.getValue(this.classLoader, this.pool, method);
    }

    private Object getDefault(String name, Method method) throws ClassNotFoundException, RuntimeException {
        String string = this.annotation.getTypeName();
        if (this.pool != null) {
            try {
                AnnotationDefaultAttribute annotationDefaultAttribute;
                CtClass ctClass = this.pool.get(string);
                ClassFile classFile = ctClass.getClassFile2();
                MethodInfo methodInfo = classFile.getMethod(name);
                if (methodInfo != null && (annotationDefaultAttribute = (AnnotationDefaultAttribute)methodInfo.getAttribute("AnnotationDefault")) != null) {
                    MemberValue memberValue = annotationDefaultAttribute.getDefaultValue();
                    return memberValue.getValue(this.classLoader, this.pool, method);
                }
            }
            catch (NotFoundException notFoundException) {
                throw new RuntimeException("cannot find a class file: " + string);
            }
        }
        throw new RuntimeException("no default value: " + string + "." + name + "()");
    }

    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            int n2 = 0;
            this.getAnnotationType();
            Method[] methodArray = this.annotationType.getDeclaredMethods();
            for (int i2 = 0; i2 < methodArray.length; ++i2) {
                String string = methodArray[i2].getName();
                int n3 = 0;
                MemberValue memberValue = this.annotation.getMemberValue(string);
                Object object = null;
                try {
                    if (memberValue != null) {
                        object = memberValue.getValue(this.classLoader, this.pool, methodArray[i2]);
                    }
                    if (object == null) {
                        object = this.getDefault(string, methodArray[i2]);
                    }
                }
                catch (RuntimeException runtimeException) {
                    RuntimeException runtimeException2 = runtimeException;
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error retrieving value " + string + " for annotation " + this.annotation.getTypeName(), exception);
                }
                if (object != null) {
                    n3 = object.getClass().isArray() ? AnnotationImpl.arrayHashCode(object) : object.hashCode();
                }
                n2 += 127 * string.hashCode() ^ n3;
            }
            this.cachedHashCode = n2;
        }
        return this.cachedHashCode;
    }

    private boolean checkEquals(Object obj) throws Exception {
        Object object;
        if (obj == null) {
            return false;
        }
        if (obj instanceof Proxy && (object = Proxy.getInvocationHandler(obj)) instanceof AnnotationImpl) {
            AnnotationImpl annotationImpl = (AnnotationImpl)object;
            return this.annotation.equals(annotationImpl.annotation);
        }
        object = (Class)JDK_ANNOTATION_TYPE_METHOD.invoke(obj, new Object[0]);
        if (!this.getAnnotationType().equals(object)) {
            return false;
        }
        Method[] methodArray = this.annotationType.getDeclaredMethods();
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            Object object2;
            String string = methodArray[i2].getName();
            MemberValue memberValue = this.annotation.getMemberValue(string);
            Object object3 = null;
            try {
                if (memberValue != null) {
                    object3 = memberValue.getValue(this.classLoader, this.pool, methodArray[i2]);
                }
                if (object3 == null) {
                    object3 = this.getDefault(string, methodArray[i2]);
                }
                object2 = methodArray[i2].invoke(obj, new Object[0]);
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2 = runtimeException;
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException("Error retrieving value " + string + " for annotation " + this.annotation.getTypeName(), exception);
            }
            if (object3 == null && object2 != null) {
                return false;
            }
            if (object3 == null || object3.equals(object2)) continue;
            return false;
        }
        return true;
    }

    private static int arrayHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        int n2 = 1;
        Object[] objectArray = (Object[])object;
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            int n3 = 0;
            if (objectArray[i2] != null) {
                n3 = objectArray[i2].hashCode();
            }
            n2 = n2 * 31 + n3;
        }
        return n2;
    }

    static {
        try {
            Class<?> clazz = Class.forName(JDK_ANNOTATION_CLASS_NAME);
            JDK_ANNOTATION_TYPE_METHOD = clazz.getMethod("annotationType", null);
        }
        catch (Exception exception) {}
    }
}

